/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.css.core.internal.document.CSSSelector;
import org.eclipse.wst.css.core.internal.parserz.CSSTextParser;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.w3c.dom.Element;

public class CSSSelectorListImpl
implements ICSSSelectorList {
    private String fText = null;
    private String fCachedString = null;
    private List fSelectors = null;

    public CSSSelectorListImpl(String cssText) {
        this.fText = cssText;
        this.parseSelectorText();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CSSSelectorListImpl foreign = (CSSSelectorListImpl)obj;
        if (this.getLength() != foreign.getLength()) {
            return false;
        }
        int i = 0;
        while (i < this.getLength()) {
            if (!this.getSelector(i).equals(foreign.getSelector(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Iterator getIterator() {
        return this.getSelectors().iterator();
    }

    public int getLength() {
        return this.getSelectors().size();
    }

    public ICSSSelector getSelector(int index) {
        List selectors = this.getSelectors();
        if (index >= 0 && index < selectors.size()) {
            return (ICSSSelector)selectors.get(index);
        }
        return null;
    }

    private List getSelectors() {
        if (this.fSelectors == null) {
            this.parseSelectorText();
        }
        return this.fSelectors;
    }

    public String getString() {
        if (this.fCachedString == null) {
            StringBuffer buf = new StringBuffer();
            boolean bFirst = true;
            Iterator i = this.getSelectors().iterator();
            while (i.hasNext()) {
                if (!bFirst) {
                    buf.append(", ");
                }
                ICSSSelector item = (ICSSSelector)i.next();
                buf.append(item.getString());
                bFirst = false;
            }
            this.fCachedString = buf.toString();
        }
        return this.fCachedString;
    }

    public boolean match(Element element, String pseudoName) {
        int nSelectors = this.getLength();
        int iSelector = 0;
        while (iSelector < nSelectors) {
            ICSSSelector selector = this.getSelector(iSelector);
            if (selector.match(element, pseudoName)) {
                return true;
            }
            ++iSelector;
        }
        return false;
    }

    private void parseSelectorText() {
        CSSSelector selector;
        this.fSelectors = new ArrayList();
        if (this.fText == null) {
            return;
        }
        CSSTextParser parser = new CSSTextParser(0, this.fText);
        CSSTextToken[] tokens = parser.getTokens();
        if (tokens.length <= 0) {
            return;
        }
        ArrayList<CSSTextToken> tokenGroup = new ArrayList<CSSTextToken>();
        int i = 0;
        while (i < tokens.length) {
            CSSTextToken token = tokens[i];
            if (token.kind == "SELECTOR_SEPARATOR" && tokenGroup.size() > 0) {
                CSSSelector selector2 = new CSSSelector(tokenGroup);
                if (selector2 != null) {
                    this.fSelectors.add(selector2);
                }
                tokenGroup.clear();
            } else {
                tokenGroup.add(tokens[i]);
            }
            ++i;
        }
        if (tokenGroup.size() > 0 && (selector = new CSSSelector(tokenGroup)) != null) {
            this.fSelectors.add(selector);
        }
    }

    public String toString() {
        return this.getString();
    }

    public Iterator getErrors() {
        ArrayList errors = new ArrayList();
        Iterator iSelector = this.getSelectors().iterator();
        while (iSelector.hasNext()) {
            Iterator iError = ((ICSSSelector)iSelector.next()).getErrors();
            while (iError.hasNext()) {
                errors.add(iError.next());
            }
        }
        return errors.iterator();
    }

    public int getErrorCount() {
        int nErrors = 0;
        Iterator i = this.getErrors();
        while (i.hasNext()) {
            ++nErrors;
            i.next();
        }
        return nErrors;
    }
}

