/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.IDataModelPausibleOperation;
import org.eclipse.wst.common.frameworks.internal.datamodel.IDataModelPausibleOperationEvent;
import org.eclipse.wst.common.frameworks.internal.datamodel.IDataModelPausibleOperationListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageGroup;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageGroupHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageHandler;
import org.eclipse.wst.common.frameworks.internal.ui.DMPageGroupElementImpl;
import org.eclipse.wst.common.frameworks.internal.ui.SimplePageGroupHandler;
import org.eclipse.wst.common.frameworks.internal.ui.SimplePageHandler;

public class PageGroupManager {
    private IDataModelPausibleOperation rootOperation;
    private IDMPageGroup rootPageGroup;
    private HashMap groupTable;
    private HashSet operationsRun;
    private Stack pageGroupStack;
    private IDataModel dataModel;
    private StackEntry savedTopEntry;
    private int savedStackSize;
    private IConfigurationElement[] elements;
    private final String ELEMENT_PAGE_GROUP = "wizardPageGroup";
    private String pauseAfterExecution = null;
    private Boolean hasMulitplePages;

    public PageGroupManager(IDataModel dataModel, IDMPageGroup rootPageGroup) {
        this.dataModel = dataModel;
        this.groupTable = new HashMap();
        this.pageGroupStack = new Stack();
        this.rootPageGroup = rootPageGroup;
        PageGroupEntry rootPageGroupEntry = new PageGroupEntry(rootPageGroup);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.common.frameworks.ui", "wizardPageGroup");
        this.elements = point.getConfigurationElements();
        this.groupTable.put(this.rootPageGroup.getPageGroupID(), rootPageGroupEntry);
        if (this.rootPageGroup.getAllowsExtendedPages()) {
            this.loadExtendedPages(rootPageGroup);
        }
    }

    public PageGroupManager(IDataModelPausibleOperation rootOperation, IDMPageGroup rootPageGroup) {
        this(rootOperation.getDataModel(), rootPageGroup);
        this.operationsRun = new HashSet();
        rootOperation.addOperationListener(new IDataModelPausibleOperationListener(){

            public int notify(IDataModelPausibleOperationEvent event) {
                switch (event.getExecutionType()) {
                    case 1: {
                        if (event.getOperationType() != 4) break;
                        PageGroupManager.this.operationsRun.remove(event.getOperation().getID());
                        break;
                    }
                    case 0: {
                        if (event.getOperationType() != 4) break;
                        PageGroupManager.this.operationsRun.add(event.getOperation().getID());
                        if (PageGroupManager.this.pauseAfterExecution == null || !event.getOperation().getID().equals(PageGroupManager.this.pauseAfterExecution)) break;
                        return 1;
                    }
                }
                return 0;
            }
        });
    }

    public void addGroupAfter(String pageGroupID, IDMPageGroup pageInsertGroup) {
        PageGroupEntry pageGroupEntry = (PageGroupEntry)this.groupTable.get(pageGroupID);
        if (pageGroupEntry.pageGroup.getAllowsExtendedPages()) {
            this.addPageGroup(pageGroupEntry.pageGroup, pageInsertGroup);
        }
    }

    public void moveForwardOnePage() {
        boolean pageFound = false;
        if (this.pageGroupStack.empty()) {
            PageGroupEntry rootEntry = (PageGroupEntry)this.groupTable.get(this.rootPageGroup.getPageGroupID());
            this.pageGroupStack.push(new StackEntry(rootEntry, -1));
        }
        this.saveStackInfo();
        try {
            pageFound = this.findNextPage(true);
        }
        catch (Exception exc) {
            Logger.getLogger().logError((Throwable)exc);
            if (this.rootOperation != null) {
                try {
                    this.rootOperation.rollBack(null, null);
                }
                catch (ExecutionException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            pageFound = false;
        }
        if (!pageFound) {
            this.restoreStackInfo();
        }
    }

    public void moveBackOnePage() {
        if (this.pageGroupStack.empty()) {
            return;
        }
        StackEntry topEntry = (StackEntry)this.pageGroupStack.peek();
        if (!topEntry.pagesReturned.empty()) {
            topEntry.pagesReturned.pop();
        }
        boolean foundPreviousPage = this.findPreviousPageInGroup();
        while (!foundPreviousPage && !this.pageGroupStack.empty()) {
            if (this.rootOperation != null && topEntry.ranOperations) {
                try {
                    this.rootOperation.rollBack(null, null);
                }
                catch (ExecutionException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            this.pageGroupStack.pop();
            if (this.pageGroupStack.empty()) continue;
            foundPreviousPage = this.findPreviousPageInGroup();
            topEntry = (StackEntry)this.pageGroupStack.peek();
        }
    }

    public void reset() {
        this.pageGroupStack.clear();
    }

    public IWizardPage getCurrentPage() {
        IWizardPage page = null;
        if (!this.pageGroupStack.empty()) {
            StackEntry topEntry = (StackEntry)this.pageGroupStack.peek();
            int pageIndex = topEntry.getTopPageIndex();
            page = pageIndex == -1 ? null : (IWizardPage)topEntry.pageGroupEntry.getPages().get(pageIndex);
        }
        return page;
    }

    public boolean hasMultiplePages() {
        if (this.hasMulitplePages == null) {
            int pageCount = 0;
            PageGroupEntry rootEntry = (PageGroupEntry)this.groupTable.get(this.rootPageGroup.getPageGroupID());
            pageCount += rootEntry.getPages().size();
            int i = 0;
            while (pageCount < 2 && i < rootEntry.groupsThatFollow.size()) {
                pageCount += ((PageGroupEntry)rootEntry.groupsThatFollow.get(i)).getPages().size();
                ++i;
            }
            this.hasMulitplePages = pageCount > 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.hasMulitplePages;
    }

    public boolean hasNextPage() {
        boolean pageFound = false;
        this.saveStackInfo();
        if (this.pageGroupStack.empty()) {
            PageGroupEntry rootEntry = (PageGroupEntry)this.groupTable.get(this.rootPageGroup.getPageGroupID());
            this.pageGroupStack.push(new StackEntry(rootEntry, -1));
        }
        pageFound = this.findNextPage(false);
        this.restoreStackInfo();
        return pageFound;
    }

    public void undoAllCurrentOperations() {
        while (!this.pageGroupStack.empty()) {
            this.moveBackOnePage();
        }
    }

    private boolean findPreviousPageInGroup() {
        StackEntry topEntry = (StackEntry)this.pageGroupStack.peek();
        boolean pageFound = false;
        if (!topEntry.pagesReturned.empty()) {
            topEntry.pagesComplete = false;
            pageFound = true;
        }
        return pageFound;
    }

    private boolean findNextPage(boolean runOperations) {
        StackEntry topEntry = (StackEntry)this.pageGroupStack.peek();
        int newPageIndex = topEntry.findNextPageIndex();
        boolean pageFound = false;
        if (newPageIndex == -1) {
            topEntry.pagesComplete = true;
            StackEntry nextStackEntry = this.findNextPageGroup(this.pageGroupStack);
            if (nextStackEntry != null) {
                IDMPageGroup pageGroup = nextStackEntry.pageGroupEntry.pageGroup;
                String requiresOperationsId = pageGroup.getRequiredDataOperationToRun();
                if (this.rootOperation != null && runOperations && requiresOperationsId != null && !this.operationsRun.contains(requiresOperationsId)) {
                    this.pauseAfterExecution = requiresOperationsId;
                    IStatus status = null;
                    try {
                        status = this.rootOperation.resume(null, null);
                    }
                    catch (ExecutionException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                    nextStackEntry.ranOperations = true;
                    if (status.getSeverity() == 4) {
                        throw new IllegalArgumentException(status.getMessage());
                    }
                }
                this.pageGroupStack.push(nextStackEntry);
                pageFound = this.findNextPage(runOperations);
            }
        } else {
            pageFound = true;
            topEntry.pagesReturned.push(new Integer(newPageIndex));
        }
        return pageFound;
    }

    private void saveStackInfo() {
        if (!this.pageGroupStack.empty()) {
            this.savedTopEntry = new StackEntry((StackEntry)this.pageGroupStack.peek());
        }
        this.savedStackSize = this.pageGroupStack.size();
    }

    private void restoreStackInfo() {
        if (this.savedStackSize == 0) {
            this.pageGroupStack.removeAllElements();
        } else {
            this.pageGroupStack.setSize(this.savedStackSize - 1);
            this.pageGroupStack.push(this.savedTopEntry);
        }
    }

    private void loadExtendedPages(IDMPageGroup pageGroup) {
        String wizardId = this.rootPageGroup.getWizardID();
        String pageGroupId = pageGroup.getPageGroupID();
        int length = this.elements.length;
        int index = 0;
        while (index < length) {
            DMPageGroupElementImpl pageInsertGroup = new DMPageGroupElementImpl(this.elements[index]);
            String pageInsertGroupId = pageInsertGroup.getPageGroupInsertionID();
            if (pageInsertGroup.getWizardID().equals(wizardId) && (pageInsertGroupId == null || pageInsertGroupId.equals(pageGroupId))) {
                this.addPageGroup(pageGroup, pageInsertGroup);
                if (pageInsertGroup.getAllowsExtendedPages()) {
                    this.loadExtendedPages(pageInsertGroup);
                }
            }
            ++index;
        }
    }

    private void addPageGroup(IDMPageGroup pageGroup, IDMPageGroup insertedPageGroup) {
        PageGroupEntry pageGroupEntry = (PageGroupEntry)this.groupTable.get(pageGroup.getPageGroupID());
        PageGroupEntry nextGroupEntry = (PageGroupEntry)this.groupTable.get(insertedPageGroup.getPageGroupID());
        if (pageGroupEntry == null) {
            pageGroupEntry = new PageGroupEntry(pageGroup);
            this.groupTable.put(pageGroup.getPageGroupID(), pageGroupEntry);
        }
        if (nextGroupEntry == null) {
            nextGroupEntry = new PageGroupEntry(insertedPageGroup);
            this.groupTable.put(insertedPageGroup.getPageGroupID(), nextGroupEntry);
        }
        pageGroupEntry.groupsThatFollow.add(nextGroupEntry);
    }

    public StackEntry findNextPageGroup(Stack stack) {
        StackEntry topEntry = (StackEntry)stack.peek();
        PageGroupEntry nextPageGroup = topEntry.getNextPageGroup(null);
        int parentIndex = topEntry.parentGroupIndex;
        int prevParentIndex = stack.size() - 1;
        while (parentIndex != -1 && nextPageGroup == null) {
            StackEntry parentStackEntry = (StackEntry)stack.elementAt(parentIndex);
            nextPageGroup = parentStackEntry.getNextPageGroup(topEntry.getId());
            prevParentIndex = parentIndex;
            parentIndex = parentStackEntry.parentGroupIndex;
            topEntry = parentStackEntry;
        }
        return nextPageGroup == null ? null : new StackEntry(nextPageGroup, prevParentIndex);
    }

    public void storeDefaultSettings(DataModelWizard wizard) {
        Iterator pageGroups = this.groupTable.values().iterator();
        while (pageGroups.hasNext()) {
            PageGroupEntry pageGroup = (PageGroupEntry)pageGroups.next();
            if (!pageGroup.isInitialized()) continue;
            Iterator pages = pageGroup.getPages().iterator();
            while (pages.hasNext()) {
                IWizardPage page = (IWizardPage)pages.next();
                wizard.storeDefaultSettings(page);
            }
        }
    }

    private class PageGroupEntry {
        public IDMPageGroup pageGroup;
        public Vector groupsThatFollow;
        private IDMPageHandler pageHandler;
        private IDMPageGroupHandler pageGroupHandler;
        private boolean initialized;

        public PageGroupEntry(IDMPageGroup newPageGroup) {
            this.pageGroup = newPageGroup;
            this.groupsThatFollow = new Vector();
            this.initialized = false;
        }

        public IDMPageHandler getPageHandler() {
            if (!this.initialized) {
                this.init();
            }
            return this.pageHandler;
        }

        public IDMPageGroupHandler getPageGroupHandler() {
            if (!this.initialized) {
                this.init();
            }
            return this.pageGroupHandler;
        }

        public List getPages() {
            if (!this.initialized) {
                this.init();
            }
            return this.pageGroup.getPages(PageGroupManager.this.dataModel);
        }

        public PageGroupEntry(PageGroupEntry originalEntry) {
            this.pageGroup = originalEntry.pageGroup;
            this.groupsThatFollow = originalEntry.groupsThatFollow;
            this.pageHandler = originalEntry.pageHandler;
            this.pageGroupHandler = originalEntry.pageGroupHandler;
        }

        private void init() {
            try {
                this.pageHandler = this.pageGroup.getPageHandler(PageGroupManager.this.dataModel);
                this.pageGroupHandler = this.pageGroup.getPageGroupHandler(PageGroupManager.this.dataModel);
            }
            catch (Exception exc) {
                Logger.getLogger().logError((Throwable)exc);
            }
            if (this.pageHandler == null) {
                this.pageHandler = new SimplePageHandler();
            }
            if (this.pageGroupHandler == null) {
                this.pageGroupHandler = new SimplePageGroupHandler();
            }
            this.initialized = true;
        }

        private int checkForSpecialIds(String pageId) {
            String beforeID;
            String afterID;
            int result = -1;
            List pages = this.getPages();
            if (pages.isEmpty() || pageId == null) {
                return -1;
            }
            result = pageId.startsWith("IDMExtendedPageHandler.PAGE_AFTER") ? ((result = this.getIndexOf(afterID = pageId.substring("IDMExtendedPageHandler.PAGE_AFTER".length(), pageId.length()))) >= 0 && result < pages.size() - 1 ? result + 1 : -1) : (pageId.startsWith("IDMExtendedPageHandler.PAGE_BEFORE") ? ((result = this.getIndexOf(beforeID = pageId.substring("IDMExtendedPageHandler.PAGE_BEFORE".length(), pageId.length()))) >= 1 && result < pages.size() ? result - 1 : -1) : this.getIndexOf(pageId));
            return result;
        }

        private int getIndexOf(String pageId) {
            int result = -1;
            List pages = this.getPages();
            int index = 0;
            while (index < pages.size()) {
                if (((IWizardPage)pages.get(index)).getName().equals(pageId)) {
                    result = index;
                    break;
                }
                ++index;
            }
            return result;
        }

        public boolean isInitialized() {
            return this.initialized;
        }
    }

    private class StackEntry {
        public PageGroupEntry pageGroupEntry;
        public Stack pagesReturned;
        public boolean pagesComplete;
        public int parentGroupIndex;
        public boolean ranOperations;

        public StackEntry(PageGroupEntry newPageGroupEntry, int parentIndex) {
            this.pageGroupEntry = newPageGroupEntry;
            this.pagesReturned = new Stack();
            this.pagesComplete = false;
            this.parentGroupIndex = parentIndex;
            this.ranOperations = false;
        }

        public StackEntry(StackEntry stackEntry) {
            this.pageGroupEntry = stackEntry.pageGroupEntry;
            this.pagesReturned = new Stack();
            this.pagesComplete = stackEntry.pagesComplete;
            this.parentGroupIndex = stackEntry.parentGroupIndex;
            this.ranOperations = stackEntry.ranOperations;
            this.pagesReturned.addAll(stackEntry.pagesReturned);
        }

        public String getId() {
            return this.pageGroupEntry.pageGroup.getPageGroupID();
        }

        public int findNextPageIndex() {
            int result = -1;
            if (!this.pagesComplete) {
                List pages = this.pageGroupEntry.getPages();
                int pageIndex = this.getTopPageIndex();
                String pageId = pageIndex == -1 ? null : ((IWizardPage)pages.get(pageIndex)).getName();
                String expectedId = pageIndex + 1 >= pages.size() ? null : ((IWizardPage)pages.get(pageIndex + 1)).getName();
                String newPageId = null;
                try {
                    newPageId = this.pageGroupEntry.getPageHandler().getNextPage(pageId, expectedId);
                }
                catch (Exception exc) {
                    Logger.getLogger().logError((Throwable)exc);
                }
                result = newPageId != null && newPageId.equals("IDMExtendedPageHandler.SKIP_PAGE") && pageIndex >= 0 && pageIndex < pages.size() - 2 ? pageIndex + 2 : this.pageGroupEntry.checkForSpecialIds(newPageId);
            }
            return result;
        }

        public PageGroupEntry getNextPageGroup(String afterId) {
            PageGroupEntry result = null;
            String nextGroupID = null;
            String[] groupIDList = this.getGroupIDList();
            try {
                nextGroupID = this.pageGroupEntry.getPageGroupHandler().getNextPageGroup(afterId, groupIDList);
            }
            catch (Exception exc) {
                Logger.getLogger().logError((Throwable)exc);
            }
            if (nextGroupID != null) {
                int index = 0;
                while (index < groupIDList.length) {
                    if (groupIDList[index].equals(nextGroupID)) {
                        result = (PageGroupEntry)this.pageGroupEntry.groupsThatFollow.elementAt(index);
                        break;
                    }
                    ++index;
                }
            }
            return result;
        }

        private String[] getGroupIDList() {
            String[] result = new String[this.pageGroupEntry.groupsThatFollow.size()];
            int index = 0;
            while (index < this.pageGroupEntry.groupsThatFollow.size()) {
                PageGroupEntry entry = (PageGroupEntry)this.pageGroupEntry.groupsThatFollow.elementAt(index);
                result[index] = entry.pageGroup.getPageGroupID();
                ++index;
            }
            return result;
        }

        private int getTopPageIndex() {
            return this.pagesReturned.empty() ? -1 : (Integer)this.pagesReturned.peek();
        }
    }
}

