/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.internal.viewers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.datatransfer.FileSystemImportWizard;
import org.eclipse.wst.common.ui.internal.Messages;
import org.eclipse.wst.common.ui.internal.viewers.ResourceFilter;

public class SelectMultiFilePage
extends WizardPage {
    IWorkbench workbench;
    IStructuredSelection selection;
    boolean isFileMandatory;
    TreeViewer sourceFileViewer;
    Button addButton;
    Button removeButton;
    Button removeAllButton;
    org.eclipse.swt.widgets.List selectedListBox;
    Button importButton;
    private Vector fFilters;
    protected IFile[] fileNames;
    IWorkspaceRoot workspaceRoot;
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final int SIZING_LISTS_WIDTH = 150;

    public SelectMultiFilePage(IWorkbench workbench, IStructuredSelection selection, boolean isFileMandatory) {
        super("SelectMultiFilePage");
        this.workbench = workbench;
        this.selection = selection;
        this.isFileMandatory = isFileMandatory;
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fileNames = null;
    }

    public void createControl(Composite parent) {
        Composite pageContent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        pageContent.setLayout((Layout)layout);
        pageContent.setLayoutData((Object)new GridData(1808));
        pageContent.getLayoutData();
        this.createLabels(pageContent);
        this.createSourceViewer(pageContent);
        this.createButtonPanel(pageContent);
        this.createSelectedListBox(pageContent);
        this.createImportButton(pageContent);
        this.setControl((Control)pageContent);
        if (this.isFileMandatory) {
            this.setPageComplete(false);
        }
    }

    public IFile[] getFiles() {
        return this.fileNames;
    }

    public void addFilterExtensions(String[] filterExtensions) {
        String[] correctedFilterExtensions = new String[filterExtensions.length];
        int i = 0;
        while (i < filterExtensions.length) {
            correctedFilterExtensions[i] = filterExtensions[i].startsWith(".") ? filterExtensions[i] : "." + filterExtensions[i];
            ++i;
        }
        ResourceFilter filter = new ResourceFilter(correctedFilterExtensions, null);
        this.addFilter(filter);
    }

    public boolean isValidSourceFileViewerSelection(ISelection selection) {
        return true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fFilters != null) {
                this.sourceFileViewer.resetFilters();
                Iterator i = this.fFilters.iterator();
                while (i.hasNext()) {
                    this.sourceFileViewer.addFilter((ViewerFilter)i.next());
                }
            }
            this.sourceFileViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        }
        super.setVisible(visible);
    }

    public void setFiles(String[] fileNames) {
        int size = Arrays.asList(fileNames).size();
        Vector<IResource> iFileNames = new Vector<IResource>();
        int i = 0;
        while (i < size) {
            IResource resource = this.workspaceRoot.findMember(fileNames[i]);
            if (resource instanceof IFile) {
                iFileNames.addElement(resource);
            }
            ++i;
        }
        IFile[] dummyArray = new IFile[iFileNames.size()];
        this.fileNames = iFileNames.toArray(dummyArray);
    }

    public void resetFilters() {
        this.fFilters = null;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new Vector();
        }
        this.fFilters.add(filter);
    }

    public void setAddButtonEnabled(boolean isEnabled) {
        this.addButton.setEnabled(isEnabled);
    }

    public void setRemoveButtonEnabled(boolean isEnabled) {
        this.removeButton.setEnabled(isEnabled);
    }

    private void createLabels(Composite pageContent) {
        Label label = new Label(pageContent, 16384);
        label.setText(Messages._UI_LABEL_SOURCE_FILES);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label = new Label(pageContent, 16384);
        label.setText(Messages._UI_LABEL_SELECTED_FILES);
    }

    public boolean checkIfFileInTarget(IFile fileToCheck) {
        String[] strings = this.selectedListBox.getItems();
        int size = this.selectedListBox.getItemCount();
        int i = 0;
        while (i < size) {
            if (strings[i].compareTo(fileToCheck.getFullPath().toString()) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void createSourceViewer(Composite parent) {
        this.sourceFileViewer = new TreeViewer(new Tree(parent, 2818));
        this.sourceFileViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.sourceFileViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.sourceFileViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                boolean newFilesSelected = false;
                if (selection instanceof IStructuredSelection) {
                    List list = ((IStructuredSelection)selection).toList();
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        IResource resource = (IResource)i.next();
                        if (!(resource instanceof IFile) || SelectMultiFilePage.this.checkIfFileInTarget((IFile)resource)) continue;
                        newFilesSelected = true;
                    }
                    SelectMultiFilePage.this.setAddButtonEnabled(newFilesSelected);
                }
            }
        });
        this.sourceFileViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectMultiFilePage.this.addSelectedFilesToTargetList();
            }
        });
        Tree treeWidget = this.sourceFileViewer.getTree();
        GridData gd = new GridData(1808);
        gd.widthHint = 150;
        gd.heightHint = 200;
        treeWidget.setLayoutData((Object)gd);
    }

    private void createButtonPanel(Composite pageContent) {
        Composite buttonPanel = new Composite(pageContent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        buttonPanel.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.horizontalAlignment = 2;
        buttonPanel.setLayoutData((Object)gridData);
        this.addButton = new Button(buttonPanel, 8);
        this.addButton.setText(Messages._UI_ADD_BUTTON);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this.addButton.setLayoutData((Object)gridData);
        this.addButton.addSelectionListener((SelectionListener)new ButtonSelectListener());
        this.addButton.setToolTipText(Messages._UI_ADD_BUTTON_TOOL_TIP);
        this.addButton.setEnabled(false);
        this.removeButton = new Button(buttonPanel, 8);
        this.removeButton.setText(Messages._UI_REMOVE_BUTTON);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.addSelectionListener((SelectionListener)new ButtonSelectListener());
        this.removeButton.setToolTipText(Messages._UI_REMOVE_BUTTON_TOOL_TIP);
        this.removeButton.setEnabled(false);
        this.removeAllButton = new Button(buttonPanel, 8);
        this.removeAllButton.setText(Messages._UI_REMOVE_ALL_BUTTON);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this.removeAllButton.setLayoutData((Object)gridData);
        this.removeAllButton.addSelectionListener((SelectionListener)new ButtonSelectListener());
        this.removeAllButton.setToolTipText(Messages._UI_REMOVE_ALL_BUTTON_TOOL_TIP);
        this.removeAllButton.setEnabled(false);
    }

    private void createSelectedListBox(Composite parent) {
        this.selectedListBox = new org.eclipse.swt.widgets.List(parent, 2818);
        this.selectedListBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (SelectMultiFilePage.this.selectedListBox.getSelectionCount() > 0) {
                    SelectMultiFilePage.this.setRemoveButtonEnabled(true);
                } else {
                    SelectMultiFilePage.this.setRemoveButtonEnabled(false);
                }
            }
        });
        GridData gd = new GridData(1808);
        gd.widthHint = 150;
        gd.heightHint = 200;
        this.selectedListBox.setLayoutData((Object)gd);
    }

    void createImportButton(Composite parent) {
        this.importButton = new Button(parent, 8);
        this.importButton.setText(Messages._UI_IMPORT_BUTTON);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        this.importButton.setLayoutData((Object)gridData);
        this.importButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileSystemImportWizard importWizard = new FileSystemImportWizard();
                importWizard.init(SelectMultiFilePage.this.workbench, SelectMultiFilePage.this.selection);
                Shell shell = Display.getCurrent().getActiveShell();
                WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)importWizard);
                wizardDialog.create();
                wizardDialog.open();
                SelectMultiFilePage.this.sourceFileViewer.refresh();
            }
        });
        this.importButton.setToolTipText(Messages._UI_IMPORT_BUTTON_TOOL_TIP);
    }

    public void addSelectedFilesToTargetList() {
        ISelection selection = this.sourceFileViewer.getSelection();
        if (this.isValidSourceFileViewerSelection(selection)) {
            List list = null;
            if (selection instanceof IStructuredSelection) {
                list = ((IStructuredSelection)selection).toList();
                if (list != null) {
                    list = ((IStructuredSelection)selection).toList();
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        String resourceName;
                        IResource resource = (IResource)i.next();
                        if (!(resource instanceof IFile) || this.selectedListBox.indexOf(resourceName = resource.getFullPath().toString()) != -1) continue;
                        this.selectedListBox.add(resourceName);
                    }
                    this.setFiles(this.selectedListBox.getItems());
                }
                this.setAddButtonEnabled(false);
                if (this.selectedListBox.getItemCount() > 0) {
                    this.removeAllButton.setEnabled(true);
                    if (this.isFileMandatory) {
                        this.setPageComplete(true);
                    }
                    if (this.selectedListBox.getSelectionCount() > 0) {
                        this.setRemoveButtonEnabled(true);
                    } else {
                        this.setRemoveButtonEnabled(false);
                    }
                }
            }
        }
    }

    class ButtonSelectListener
    implements SelectionListener {
        ButtonSelectListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == SelectMultiFilePage.this.addButton) {
                SelectMultiFilePage.this.addSelectedFilesToTargetList();
            } else if (e.widget == SelectMultiFilePage.this.removeButton) {
                String[] strings = SelectMultiFilePage.this.selectedListBox.getSelection();
                int size = SelectMultiFilePage.this.selectedListBox.getSelectionCount();
                int i = 0;
                while (i < size) {
                    SelectMultiFilePage.this.selectedListBox.remove(strings[i]);
                    ++i;
                }
                SelectMultiFilePage.this.removeButton.setEnabled(false);
                if (SelectMultiFilePage.this.selectedListBox.getItemCount() == 0) {
                    SelectMultiFilePage.this.removeAllButton.setEnabled(false);
                    if (SelectMultiFilePage.this.isFileMandatory) {
                        SelectMultiFilePage.this.setPageComplete(false);
                    }
                }
                SelectMultiFilePage.this.setFiles(SelectMultiFilePage.this.selectedListBox.getItems());
            } else if (e.widget == SelectMultiFilePage.this.removeAllButton) {
                SelectMultiFilePage.this.selectedListBox.removeAll();
                SelectMultiFilePage.this.removeButton.setEnabled(false);
                SelectMultiFilePage.this.removeAllButton.setEnabled(false);
                if (SelectMultiFilePage.this.isFileMandatory) {
                    SelectMultiFilePage.this.setPageComplete(false);
                }
                SelectMultiFilePage.this.setFiles(SelectMultiFilePage.this.selectedListBox.getItems());
            }
        }
    }
}

