/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.J2EEPropertiesConstants;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.web.internal.operation.WebProjectPropertiesUpdateDataModelProvider;

public class J2EEPropertiesPage
extends PropertyPage
implements J2EEPropertiesConstants {
    protected IProject project = null;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    Text contextRootNameField;
    Text webContentFolderField;

    protected Control createContents(Composite parent) {
        Composite control = null;
        this.project = this.getProject();
        if (this.project != null) {
            Composite containerGroup;
            control = containerGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            containerGroup.setLayout((Layout)layout);
            this.fillInformation(this.project, containerGroup);
        }
        Dialog.applyDialogFont((Control)parent);
        return control;
    }

    private void fillInformation(IProject p, Composite c) {
        try {
            if (J2EEProjectUtilities.getJ2EEProjectType((IProject)p).equals("jst.web") || J2EEProjectUtilities.getJ2EEProjectType((IProject)p).equals("wst.web")) {
                this.fillContextRoot(p, c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillContextRoot(IProject p, Composite c) {
        Label contextRootLabel = new Label(c, 0);
        contextRootLabel.setText(J2EEPropertiesConstants.WEB_CONTEXT_ROOT);
        GridData data = new GridData();
        data.horizontalIndent = 15;
        contextRootLabel.setLayoutData((Object)data);
        this.contextRootNameField = new Text(c, 2048);
        data = new GridData(768);
        data.widthHint = 250;
        this.contextRootNameField.setLayoutData((Object)data);
        this.contextRootNameField.setEditable(true);
        String s = J2EEProjectUtilities.getServerContextRoot((IProject)p);
        if (s == null) {
            s = "";
        }
        this.contextRootNameField.setText(s);
        this.contextRootNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newContextRoot = J2EEPropertiesPage.this.contextRootNameField.getText();
                J2EEPropertiesPage.this.validateContextRoot(newContextRoot);
            }
        });
    }

    private IProject getProject() {
        if (this.project == null) {
            IAdaptable element = this.getElement();
            if (element == null) {
                return null;
            }
            if (element instanceof IProject) {
                this.project = (IProject)element;
                return this.project;
            }
            return null;
        }
        return this.project;
    }

    private String getContextRoot() {
        return this.contextRootNameField != null ? this.contextRootNameField.getText() : null;
    }

    protected boolean hasUpdatedInformation() {
        return this.hasContextRootChanged();
    }

    private boolean hasContextRootChanged() {
        String oldContextRoot = J2EEProjectUtilities.getServerContextRoot((IProject)this.project);
        if (oldContextRoot == null) {
            return true;
        }
        return !oldContextRoot.equals(this.getContextRoot());
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.contextRootNameField != null) {
            this.contextRootNameField.setText(J2EEProjectUtilities.getServerContextRoot((IProject)this.project));
        }
    }

    public boolean performOk() {
        boolean retVal = true;
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebProjectPropertiesUpdateDataModelProvider());
        model.setProperty("IWebProjectPropertiesUpdateDataModelProperties.PROJECT", (Object)this.project);
        model.setStringProperty("IWebProjectPropertiesUpdateDataModelProperties.CONTEXT_ROOT", this.getContextRoot());
        try {
            model.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return retVal;
    }

    public void validateContextRoot(String name) {
        boolean bValid = true;
        if (name == null) {
            this.setErrorMessage(ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Context_Root_cannot_be_empty_2, (Object[])new Object[0]));
            bValid = false;
        }
        if (name.indexOf(32) <= -1) {
            StringTokenizer stok = new StringTokenizer(name, ".");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                int i = 0;
                while (i < token.length()) {
                    if (token.charAt(i) != '_' && token.charAt(i) != '-' && token.charAt(i) != '/' && !Character.isLetterOrDigit(token.charAt(i)) && !Character.isWhitespace(token.charAt(i))) {
                        this.setErrorMessage(ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.The_character_is_invalid_in_a_context_root, (Object[])new Object[]{new Character(token.charAt(i)).toString()}));
                        bValid = false;
                    }
                    ++i;
                }
            }
        } else {
            this.setErrorMessage(ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Names_cannot_contain_whitespace_, (Object[])new Object[0]));
            bValid = false;
        }
        if (bValid) {
            this.setErrorMessage(null);
        }
        this.setValid(bValid);
    }
}

