/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.operation.FacetProjectCreationOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.datamodel.DataModelPausibleOperationImpl;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.common.project.facet.ui.internal.AbstractDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.ChangeTargetedRuntimesDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.ModifyFacetedProjectDataModel;
import org.eclipse.wst.web.internal.DelegateConfigurationElement;
import org.eclipse.wst.web.ui.internal.Logger;
import org.eclipse.wst.web.ui.internal.WSTWebUIPlugin;

public abstract class NewProjectDataModelFacetWizard
extends ModifyFacetedProjectWizard
implements INewWizard,
IFacetProjectCreationDataModelProperties {
    protected IDataModel model = null;
    private final IFacetedProjectTemplate template;
    private IWizardPage[] beginingPages;
    private IConfigurationElement configurationElement;

    public NewProjectDataModelFacetWizard(IDataModel model) {
        super(null);
        this.model = model;
        this.template = this.getTemplate();
        this.setDefaultPageImageDescriptor(this.getDefaultPageImageDescriptor());
    }

    public NewProjectDataModelFacetWizard() {
        super(null);
        this.model = this.createDataModel();
        this.template = this.getTemplate();
        this.setDefaultPageImageDescriptor(this.getDefaultPageImageDescriptor());
    }

    public IDataModel getDataModel() {
        return this.model;
    }

    protected abstract IDataModel createDataModel();

    protected abstract ImageDescriptor getDefaultPageImageDescriptor();

    protected abstract IFacetedProjectTemplate getTemplate();

    protected abstract IWizardPage createFirstPage();

    protected IWizardPage[] createBeginingPages() {
        return new IWizardPage[]{this.createFirstPage()};
    }

    public void addPages() {
        this.beginingPages = this.createBeginingPages();
        int i = 0;
        while (i < this.beginingPages.length) {
            this.addPage(this.beginingPages[i]);
            ++i;
        }
        super.addPages();
        Set fixed = this.template.getFixedProjectFacets();
        this.facetsSelectionPage.setFixedProjectFacets(fixed);
        this.facetsSelectionPage.addSelectedFacetsChangedListener(new Listener(){

            public void handleEvent(Event event) {
                NewProjectDataModelFacetWizard.this.facetSelectionChangedEvent(event);
            }
        });
    }

    public void createPageControls(Composite container) {
        super.createPageControls(container);
        IPreset preset = this.template.getInitialPreset();
        IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        if (preset == null) {
            this.setRuntimeAndDefaultFacets(runtime);
        } else {
            this.facetsSelectionPage.panel.getDataModel().setSelectedPreset(preset.getId());
            boolean supports = false;
            if (runtime != null) {
                supports = true;
                for (IProjectFacetVersion fv : preset.getProjectFacets()) {
                    if (runtime.supports(fv)) continue;
                    supports = false;
                    break;
                }
            }
            ChangeTargetedRuntimesDataModel rdm = this.getModel().getTargetedRuntimesDataModel();
            if (supports) {
                rdm.setTargetedRuntimes(Collections.singleton(runtime));
            } else {
                this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", null);
            }
        }
        this.synchRuntimes();
        this.facetsSelectionPage.setInitialSelection(this.getFacetsFromDataModel());
    }

    protected Set getFacetsFromDataModel() {
        HashSet<Object> facetVersions = new HashSet<Object>();
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        for (IDataModel facetModel : map.values()) {
            if (!facetModel.getBooleanProperty("IFacetDataModelProperties.SHOULD_EXECUTE")) continue;
            facetVersions.add(facetModel.getProperty("IFacetDataModelPropeties.FACET_VERSION"));
        }
        IFacetProjectCreationDataModelProperties.FacetActionMap mapAction = (IFacetProjectCreationDataModelProperties.FacetActionMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP");
        for (IFacetedProject.Action action : mapAction.values()) {
            facetVersions.add(action.getProjectFacetVersion());
        }
        return facetVersions;
    }

    public IWizardPage[] getPages() {
        IWizardPage[] base = super.getPages();
        IWizardPage[] pages = new IWizardPage[base.length + this.beginingPages.length];
        int i = 0;
        while (i < this.beginingPages.length) {
            pages[i] = this.beginingPages[i];
            ++i;
        }
        System.arraycopy(base, 0, pages, this.beginingPages.length, base.length);
        return pages;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected void synchRuntimes() {
        final ChangeTargetedRuntimesDataModel rdm = this.getModel().getTargetedRuntimesDataModel();
        final Boolean[] suppressBackEvents = new Boolean[]{Boolean.FALSE};
        this.model.addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ((1 == event.getFlag() || 2 == event.getFlag()) && "IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(event.getPropertyName()) && !suppressBackEvents[0].booleanValue()) {
                    IRuntime runtime = (IRuntime)event.getProperty();
                    NewProjectDataModelFacetWizard.this.setRuntimeAndDefaultFacets(runtime);
                }
            }
        });
        rdm.addListener("primaryRuntimeChanged", new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                suppressBackEvents[0] = Boolean.TRUE;
                NewProjectDataModelFacetWizard.this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)rdm.getPrimaryRuntime());
                suppressBackEvents[0] = Boolean.FALSE;
            }
        });
    }

    protected void setRuntimeAndDefaultFacets(IRuntime runtime) {
        ModifyFacetedProjectDataModel dm = this.getModel();
        ChangeTargetedRuntimesDataModel rdm = dm.getTargetedRuntimesDataModel();
        rdm.setTargetedRuntimes(Collections.EMPTY_SET);
        this.facetsSelectionPage.setDefaultFacetsForRuntime(runtime);
        if (runtime != null) {
            rdm.setTargetedRuntimes(Collections.singleton(runtime));
        }
        dm.setSelectedPreset("default.configuration");
    }

    public String getProjectName() {
        return this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
    }

    protected void performFinish(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 10);
        this.storeDefaultSettings();
        try {
            FacetProjectCreationOperation operation = new FacetProjectCreationOperation(this.model);
            this.fproj = operation.createProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            super.performFinish((IProgressMonitor)new SubProgressMonitor(monitor, 8));
            Set fixed = this.template.getFixedProjectFacets();
            this.fproj.setFixedProjectFacets(fixed);
            try {
                this.getFacetProjectNotificationOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = "";
                }
                Status st = new Status(4, "org.eclipse.wst.web.ui", 0, msg, (Throwable)e);
                throw new CoreException((IStatus)st);
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        try {
            this.postPerformFinish();
        }
        catch (InvocationTargetException e) {
            Logger.logException(e);
        }
        return true;
    }

    protected String getFinalPerspectiveID() {
        return null;
    }

    public final void setInitializationData(IConfigurationElement aConfigurationElement, String aPropertyName, Object theData) throws CoreException {
        this.configurationElement = aConfigurationElement;
        this.doSetInitializeData(aConfigurationElement, aPropertyName, theData);
    }

    protected void doSetInitializeData(IConfigurationElement aConfigurationElement, String aPropertyName, Object theData) {
    }

    public final String getPluginId() {
        return this.configurationElement != null ? this.configurationElement.getDeclaringExtension().getNamespace() : "";
    }

    protected void postPerformFinish() throws InvocationTargetException {
        if (this.getFinalPerspectiveID() != null && this.getFinalPerspectiveID().length() > 0) {
            DelegateConfigurationElement element = new DelegateConfigurationElement(this.configurationElement){

                public String getAttribute(String aName) {
                    if (aName.equals("finalPerspective")) {
                        return NewProjectDataModelFacetWizard.this.getFinalPerspectiveID();
                    }
                    return super.getAttribute(aName);
                }
            };
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)element);
        } else {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        }
        String projName = this.getProjectName();
        BasicNewResourceWizard.selectAndReveal((IResource)ResourcesPlugin.getWorkspace().getRoot().getProject(projName), (IWorkbenchWindow)WSTWebUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow());
    }

    protected IDataModelOperation getFacetProjectNotificationOperation() {
        return new DataModelPausibleOperationImpl((IDataModelOperation)new AbstractDataModelOperation(this.model){

            public String getID() {
                return NewProjectDataModelFacetWizard.class.getName();
            }

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return AbstractDataModelProvider.OK_STATUS;
            }
        });
    }

    protected void facetSelectionChangedEvent(Event event) {
        Set actions = this.facetsSelectionPage.getActions();
        Iterator iterator = actions.iterator();
        HashSet<String> activeIds = new HashSet<String>();
        while (iterator.hasNext()) {
            IFacetedProject.Action action = (IFacetedProject.Action)iterator.next();
            String id = action.getProjectFacetVersion().getProjectFacet().getId();
            activeIds.add(id);
        }
        IFacetProjectCreationDataModelProperties.FacetDataModelMap dataModelMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        for (String id : dataModelMap.keySet()) {
            IDataModel configDM = (IDataModel)dataModelMap.get((Object)id);
            boolean active = activeIds.contains(id);
            configDM.setBooleanProperty("IFacetDataModelProperties.SHOULD_EXECUTE", active);
            activeIds.remove(id);
        }
        IFacetProjectCreationDataModelProperties.FacetActionMap actionMap = (IFacetProjectCreationDataModelProperties.FacetActionMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP");
        actionMap.clear();
        for (IFacetedProject.Action action : actions) {
            String id = action.getProjectFacetVersion().getProjectFacet().getId();
            if (!activeIds.contains(id)) continue;
            actionMap.add(action);
        }
        this.model.notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 4);
    }

    public Object getConfig(IProjectFacetVersion fv, IFacetedProject.Action.Type type, String pjname) throws CoreException {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel configDM = (IDataModel)map.get((Object)fv.getProjectFacet().getId());
        if (configDM == null) {
            Object config = fv.createActionConfig(type, pjname);
            if (config == null || !(config instanceof IDataModel)) {
                return null;
            }
            configDM = (IDataModel)config;
            map.add(configDM);
        }
        configDM.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)fv);
        return configDM;
    }

    protected void storeDefaultSettings() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            this.storeDefaultSettings(pages[i], i);
            ++i;
        }
    }

    protected void storeDefaultSettings(IWizardPage page, int pageIndex) {
        if (page instanceof DataModelWizardPage) {
            ((DataModelWizardPage)page).storeDefaultSettings();
        }
    }
}

