/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class RunOnServerLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected IServer server;
    protected IModule module;
    protected ModuleArtifactDelegate moduleArtifact;
    protected ILaunchableAdapter launchableAdapter;
    protected IClient client;
    protected Label serverLabel;
    protected Label moduleArtifactLabel;
    protected Label clientLabel;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.serverLaunchServer);
        this.serverLabel = new Label(composite, 0);
        this.serverLabel.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 0);
        label.setText("Artifact:");
        this.moduleArtifactLabel = new Label(composite, 0);
        this.moduleArtifactLabel.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 0);
        label.setText("Client:");
        this.clientLabel = new Label(composite, 0);
        this.clientLabel.setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.setErrorMessage(null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        try {
            String serverId = configuration.getAttribute("server-id", null);
            String moduleArt = configuration.getAttribute("module-artifact", null);
            String moduleArtifactClass = configuration.getAttribute("module-artifact-class", null);
            String laId = configuration.getAttribute("launchable-adapter-id", null);
            String clientId = configuration.getAttribute("client-id", null);
            this.server = ServerCore.findServer((String)serverId);
            this.module = null;
            this.moduleArtifact = null;
            this.launchableAdapter = ServerPlugin.findLaunchableAdapter((String)laId);
            this.client = ServerPlugin.findClient((String)clientId);
            try {
                Class<?> c = Class.forName(moduleArtifactClass);
                this.moduleArtifact = (ModuleArtifactDelegate)c.newInstance();
                this.moduleArtifact.deserialize(moduleArt);
                this.module = this.moduleArtifact.getModule();
            }
            catch (Throwable throwable) {
                Trace.trace((byte)2, "Could not load module artifact delegate class");
            }
            if (this.server == null) {
                this.serverLabel.setText("unknown");
            } else {
                this.serverLabel.setText(this.server.getName());
            }
            if (this.moduleArtifact == null) {
                this.moduleArtifactLabel.setText("unknown");
            } else {
                this.moduleArtifactLabel.setText(this.moduleArtifact.getName());
            }
            if (this.client == null) {
                this.clientLabel.setText("unknown");
            } else {
                this.clientLabel.setText(this.client.getName());
            }
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        block4: {
            IServer server2;
            block5: {
                try {
                    String id = launchConfig.getAttribute("server-id", "");
                    if (id == null || id.equals("")) break block4;
                    server2 = ServerCore.findServer((String)id);
                    if (server2 != null) break block5;
                    return false;
                }
                catch (CoreException coreException) {}
            }
            if (server2.getServerState() == 4) {
                return true;
            }
        }
        return false;
    }

    public Image getImage() {
        return ImageResource.getImage("IMG_ETOOL_CLIENT");
    }

    public String getName() {
        return Messages.serverLaunchConfigurationTab;
    }
}

