/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.editor.IOrdered;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorActionFactory;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPageSectionFactory;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartFactory;

public class ServerEditorCore {
    private static List editorPageFactories;
    private static List editorPageSectionFactories;
    private static List editorActionFactories;

    public static List getServerEditorPageFactories() {
        if (editorPageFactories == null) {
            ServerEditorCore.loadEditorPageFactories();
        }
        return editorPageFactories;
    }

    public static List getServerEditorPageSectionFactories() {
        if (editorPageSectionFactories == null) {
            ServerEditorCore.loadEditorPageSectionFactories();
        }
        return editorPageSectionFactories;
    }

    private static void loadEditorPageFactories() {
        Trace.trace((byte)0, "->- Loading .editorPages extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.ui", "editorPages");
        ArrayList list = new ArrayList(cf.length);
        ServerEditorCore.loadEditorPageFactories(cf, list);
        editorPageFactories = list;
        ServerUIPlugin.addRegistryListener();
        Trace.trace((byte)0, "-<- Done loading .editorPages extension point -<-");
    }

    private static void loadEditorPageFactories(IConfigurationElement[] cf, List list) {
        int size = cf.length;
        int i = 0;
        while (i < size) {
            try {
                list.add(new ServerEditorPartFactory(cf[i]));
                Trace.trace((byte)0, "  Loaded editorPage: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load editorPage: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        ServerEditorCore.sortOrderedList(list);
    }

    public static void handleEditorPageFactoriesDelta(IExtensionDelta delta) {
        if (editorPageFactories == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        ArrayList list = new ArrayList(editorPageFactories);
        if (delta.getKind() == 1) {
            ServerEditorCore.loadEditorPageFactories(cf, list);
        } else {
            int size = list.size();
            ServerEditorPartFactory[] sepf = new ServerEditorPartFactory[size];
            list.toArray(sepf);
            int size2 = cf.length;
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size2) {
                    if (sepf[i].getId().equals(cf[j].getAttribute("id"))) {
                        list.remove(sepf[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        editorPageFactories = list;
    }

    private static void loadEditorPageSectionFactories() {
        Trace.trace((byte)0, "->- Loading .editorPageSections extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.ui", "editorPageSections");
        ArrayList list = new ArrayList(cf.length);
        ServerEditorCore.loadEditorPageSectionFactories(cf, list);
        editorPageSectionFactories = list;
        ServerUIPlugin.addRegistryListener();
        Trace.trace((byte)0, "-<- Done loading .editorPageSections extension point -<-");
    }

    private static void loadEditorPageSectionFactories(IConfigurationElement[] cf, List list) {
        int size = cf.length;
        int i = 0;
        while (i < size) {
            try {
                list.add(new ServerEditorPageSectionFactory(cf[i]));
                Trace.trace((byte)0, "  Loaded editorPageSection: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load editorPageSection: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        ServerEditorCore.sortOrderedList(list);
    }

    public static void handleEditorPageSectionFactoriesDelta(IExtensionDelta delta) {
        if (editorPageSectionFactories == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        ArrayList list = new ArrayList(editorPageSectionFactories);
        if (delta.getKind() == 1) {
            ServerEditorCore.loadEditorPageSectionFactories(cf, list);
        } else {
            int size = list.size();
            ServerEditorPageSectionFactory[] seps = new ServerEditorPageSectionFactory[size];
            list.toArray(seps);
            int size2 = cf.length;
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size2) {
                    if (seps[i].getId().equals(cf[j].getAttribute("id"))) {
                        list.remove(seps[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        editorPageSectionFactories = list;
    }

    public static List getServerEditorActionFactories() {
        if (editorActionFactories == null) {
            ServerEditorCore.loadEditorActionFactories();
        }
        return editorActionFactories;
    }

    private static void loadEditorActionFactories() {
        Trace.trace((byte)0, "->- Loading .editorActions extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.ui", "editorActions");
        int size = cf.length;
        ArrayList<ServerEditorActionFactory> list = new ArrayList<ServerEditorActionFactory>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new ServerEditorActionFactory(cf[i]));
                Trace.trace((byte)0, "  Loaded editorAction: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load editorAction: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        ServerEditorCore.sortOrderedList(list);
        editorActionFactories = list;
        Trace.trace((byte)0, "-<- Done loading .editorActions extension point -<-");
    }

    public static List sortOrderedList(List list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        int i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                IOrdered a = (IOrdered)list.get(i);
                IOrdered b = (IOrdered)list.get(j);
                if (a.getOrder() > b.getOrder()) {
                    IOrdered temp = a;
                    list.set(i, b);
                    list.set(j, temp);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }
}

