/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.notation.stylepooling;

public class ShapeProfiler {
    private final Runtime s_runtime = Runtime.getRuntime();
    long startMemory = 0L;
    long endMemory = 0L;
    long startTime = 0L;
    long endTime = 0L;

    private long usedMemory() {
        return this.s_runtime.totalMemory() - this.s_runtime.freeMemory();
    }

    private void runGC() {
        int r = 0;
        while (r < 4) {
            this.s_runtime.gc();
            ++r;
        }
    }

    private void initProfile() {
        this.startMemory = 0L;
        this.endMemory = 0L;
        this.startTime = 0L;
        this.endTime = 0L;
    }

    public void profileStart() {
        this.initProfile();
        this.runGC();
        this.startMemory = this.usedMemory();
        this.startTime = System.currentTimeMillis();
    }

    public void profileEnd() {
        this.endTime = System.currentTimeMillis();
        this.runGC();
        this.endMemory = this.usedMemory();
    }

    public void printStats() {
        long difference = this.endMemory - this.startMemory;
        long timeDiff = this.endTime - this.startTime;
        System.out.println("bytes=" + difference + "\ttim ms=" + timeDiff);
    }
}

