/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.parser;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.InvalidType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.AbstractVisitor;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.ocl.utilities.UtilitiesPackage;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
implements Visitor<Boolean, C, O, P, EL, PM, S, COA, SSA, CT> {
    private Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env = null;
    private UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml = null;

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> Visitor<Boolean, C, O, P, EL, PM, S, COA, SSA, CT> getInstance(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment) {
        if (environment == null) {
            throw new NullPointerException();
        }
        return new ValidationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(environment);
    }

    private ValidationVisitor(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment) {
        this.env = environment;
        this.uml = environment.getUMLReflection();
    }

    @Override
    public Boolean visitOperationCallExp(OperationCallExp<C, O> oc) {
        OCLExpression source = oc.getSource();
        O oper = oc.getReferredOperation();
        int opcode = oc.getOperationCode();
        List args = (List)oc.getArgument();
        if (oper == null) {
            String message = OCLMessages.bind(OCLMessages.NullOperation_ERROR_, oc.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
            throw error;
        }
        if (source == null) {
            String message = OCLMessages.bind(OCLMessages.NullSourceOperation_ERROR_, oc.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
            throw error;
        }
        Object sourceType = source.getType();
        String operName = this.getName(oper);
        for (OCLExpression expr : args) {
            expr.accept(this);
        }
        this.visitFeatureCallExp(oc);
        if (opcode == 71 && !this.env.isInPostcondition(oc)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.OCLIsNewInPostcondition_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
            throw error;
        }
        source.accept(this);
        try {
            C resultType;
            String message;
            O oper1 = this.env.lookupOperation(sourceType, operName, args);
            if (oper1 != oper) {
                message = OCLMessages.bind(OCLMessages.IllegalOperation_ERROR_, oc.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                throw error;
            }
            if (!this.uml.isQuery(oper)) {
                message = OCLMessages.bind(OCLMessages.NonQueryOperation_ERROR_, this.getName(oper));
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                throw error;
            }
            if (sourceType instanceof PredefinedType) {
                if (opcode != OCLStandardLibraryUtil.getOperationCode(operName)) {
                    String message2 = OCLMessages.bind(OCLMessages.IllegalOpcode_ERROR_, operName);
                    IllegalArgumentException error = new IllegalArgumentException(message2);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                resultType = OCLStandardLibraryUtil.getResultTypeOf(this.env, sourceType, opcode, args);
                if (resultType == null) {
                    resultType = this.uml.getOCLType(oper);
                }
            } else if (TypeUtil.isOclAnyOperation(this.env, oper)) {
                if (opcode != OCLStandardLibraryUtil.getOclAnyOperationCode(operName)) {
                    String message3 = OCLMessages.bind(OCLMessages.IllegalOpcode_ERROR_, operName);
                    IllegalArgumentException error = new IllegalArgumentException(message3);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                resultType = OCLStandardLibraryUtil.getResultTypeOf(this.env, sourceType, opcode, args);
                if (resultType == null) {
                    resultType = this.uml.getOCLType(oper);
                }
            } else {
                resultType = this.uml.getOCLType(oper);
            }
            if (TypeUtil.typeCompare(this.env, resultType, oc.getType()) != 0) {
                String message4 = OCLMessages.bind(OCLMessages.TypeConformanceOperation_ERROR_, oc.getType().toString());
                IllegalArgumentException error = new IllegalArgumentException(message4);
                OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                throw error;
            }
        }
        catch (Exception e) {
            IllegalArgumentException error = new IllegalArgumentException(e.getMessage());
            OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitEnumLiteralExp(EnumLiteralExp<C, EL> el) {
        EL l = el.getReferredEnumLiteral();
        Object type = el.getType();
        if (!this.uml.isEnumeration(type) || this.uml.getEnumeration(l) != type) {
            String message = OCLMessages.bind(OCLMessages.IllegalEnumLiteral_ERROR_, el.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitEnumLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitVariableExp(VariableExp<C, PM> v) {
        Variable<C, PM> vd = v.getReferredVariable();
        if (vd == null || v.getType() == null || vd.getName() == null || vd.getType() == null) {
            String message = OCLMessages.bind(OCLMessages.IncompleteVariableExp_ERROR_, v.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitVariableExp", error);
            throw error;
        }
        vd.accept(this);
        if (TypeUtil.typeCompare(this.env, vd.getType(), v.getType()) != 0) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.VariableTypeMismatch_ERROR_, vd.getName()));
            OCLPlugin.throwing(this.getClass(), "visitVariableExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitPropertyCallExp(PropertyCallExp<C, P> pc) {
        P property = pc.getReferredProperty();
        OCLExpression source = pc.getSource();
        Object type = pc.getType();
        if (property == null) {
            String message = OCLMessages.bind(OCLMessages.NullProperty_ERROR_, pc.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitPropertyCallExp", error);
            throw error;
        }
        if (source == null) {
            String message = OCLMessages.bind(OCLMessages.NullNavigationSource_ERROR_, pc.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitPropertyCallExp", error);
            throw error;
        }
        if (type == null) {
            String message = OCLMessages.bind(OCLMessages.NullNavigationType_ERROR_, pc.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitPropertyCallExp", error);
            throw error;
        }
        List qualifiers = (List)pc.getQualifier();
        if (!qualifiers.isEmpty()) {
            List<P> expectedQualifierTypes = this.uml.getQualifiers(property);
            if (expectedQualifierTypes.size() != qualifiers.size()) {
                String message = OCLMessages.bind(OCLMessages.MismatchedQualifiers_ERROR_, pc.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitPropertyCallExp", error);
                throw error;
            }
            Iterator<P> eiter = expectedQualifierTypes.iterator();
            Iterator qiter = qualifiers.iterator();
            while (eiter.hasNext()) {
                C expectedType = this.uml.getOCLType(eiter.next());
                OCLExpression qualifier = (OCLExpression)qiter.next();
                Object qualifierType = qualifier.getType();
                if ((TypeUtil.getRelationship(this.env, qualifierType, expectedType) & 3) != 0) continue;
                String message = OCLMessages.bind(OCLMessages.MismatchedQualifiers_ERROR_, pc.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitPropertyCallExp", error);
                throw error;
            }
        }
        this.visitFeatureCallExp(pc);
        source.accept(this);
        C refType = TypeUtil.getPropertyType(this.env, source.getType(), property);
        if (!pc.getQualifier().isEmpty() && refType instanceof CollectionType) {
            CollectionType ct = (CollectionType)refType;
            refType = ct.getElementType();
        }
        return TypeUtil.typeCompare(this.env, refType, type) == 0;
    }

    @Override
    public Boolean visitAssociationClassCallExp(AssociationClassCallExp<C, P> ae) {
        Object end;
        C ref = ae.getReferredAssociationClass();
        OCLExpression source = ae.getSource();
        Object type = ae.getType();
        if (ref == null) {
            String message = OCLMessages.bind(OCLMessages.MissingAssociationClass_ERROR_, ae.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitAssociationClassCallExp", error);
            throw error;
        }
        if (source == null) {
            String message = OCLMessages.bind(OCLMessages.NullNavigationSource_ERROR_, ae.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitAssociationClassCallExp", error);
            throw error;
        }
        Object sourceType = source.getType();
        if (type == null) {
            String message = OCLMessages.bind(OCLMessages.NullNavigationType_ERROR_, ae.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitAssociationClassCallExp", error);
            throw error;
        }
        if (type instanceof CollectionType) {
            Object elementType = ((CollectionType)type).getElementType();
            type = elementType;
        }
        if (ae.getNavigationSource() != null && (ref != this.uml.getAssociationClass(end = ae.getNavigationSource()) || end != this.env.lookupProperty(sourceType, this.getName(end)))) {
            String message = OCLMessages.bind(OCLMessages.AssociationClassQualifierType_ERROR_, ae.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitAssociationClassCallExp", error);
            throw error;
        }
        this.visitFeatureCallExp(ae);
        source.accept(this);
        if (TypeUtil.typeCompare(this.env, ref, type) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitVariable(Variable<C, PM> vd) {
        String varName = vd.getName();
        if (varName == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.MissingNameInVariableDeclaration_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitVariableDeclaration", error);
            throw error;
        }
        Object type = vd.getType();
        OCLExpression<C> init = vd.getInitExpression();
        if (init != null) {
            init.accept(this);
            if (TypeUtil.typeCompare(this.env, init.getType(), type) > 0) {
                IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.TypeConformanceInit_ERROR_, varName));
                OCLPlugin.throwing(this.getClass(), "visitVariableDeclaration", error);
                throw error;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitIfExp(IfExp<C> i) {
        OCLExpression<C> cond = i.getCondition();
        OCLExpression<C> thenexp = i.getThenExpression();
        OCLExpression<C> elseexp = i.getElseExpression();
        if (cond == null || thenexp == null | elseexp == null) {
            String message = OCLMessages.bind(OCLMessages.IncompleteIfExp_ERROR_, i.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIfExp", error);
            throw error;
        }
        cond.accept(this);
        thenexp.accept(this);
        elseexp.accept(this);
        if (cond.getType() != this.getStandardLibrary().getBoolean()) {
            String message = OCLMessages.bind(OCLMessages.NonBooleanIfExp_ERROR_, cond.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIfExp", error);
            throw error;
        }
        Object thenelsetype = null;
        try {
            thenelsetype = TypeUtil.commonSuperType(this.env, thenexp.getType(), elseexp.getType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (TypeUtil.typeCompare(this.env, i.getType(), thenelsetype) != 0) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceIfExp_ERROR_, i.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIfExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitMessageExp(MessageExp<C, COA, SSA> m) {
        List<Object> parameters;
        if (m.getTarget() == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.MissingMessageTarget_ERROR_, m.toString()));
            OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
            throw error;
        }
        m.getTarget().accept(this);
        if (m.getCalledOperation() == null && m.getSentSignal() == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.UnrecognizedMessageType_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
            throw error;
        }
        if (m.getCalledOperation() != null && m.getSentSignal() != null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.AmbiguousMessageType_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
            throw error;
        }
        if (m.getCalledOperation() != null) {
            O operation = this.uml.getOperation(m.getCalledOperation());
            if (operation == null) {
                IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.MissingOperationInCallAction_ERROR_, m.toString()));
                OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
                throw error;
            }
            parameters = this.uml.getParameters(operation);
        } else {
            C signal = this.uml.getSignal(m.getSentSignal());
            if (signal == null) {
                IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.MissingSignalInCallAction_ERROR_, m.toString()));
                OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
                throw error;
            }
            parameters = this.uml.getAttributes(signal);
        }
        List arguments = (List)m.getArgument();
        if (arguments.size() != parameters.size()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.MessageArgumentCount_ERROR_, this.getName(m.getType())));
            OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
            throw error;
        }
        Iterator<Object> paramsIter = parameters.iterator();
        Iterator argsIter = arguments.iterator();
        while (paramsIter.hasNext()) {
            Object param = paramsIter.next();
            OCLExpression arg = (OCLExpression)argsIter.next();
            if (TypeUtil.typeCompare(this.env, arg.getType(), this.uml.getOCLType(param)) > 0) {
                IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.MessageArgConformance_ERROR_, this.getName(param), arg.toString()));
                OCLPlugin.throwing(this.getClass(), "visitMessageExp", error);
                throw error;
            }
            arg.accept(this);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitUnspecifiedValueExp(UnspecifiedValueExp<C> uv) {
        if (!(uv.eContainer() instanceof MessageExp)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.IllegalUnspecifiedValueExp_ERROR_, uv.toString()));
            OCLPlugin.throwing(this.getClass(), "visitUnspecifiedValueExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitTypeExp(TypeExp<C> t) {
        if (!(t.getType() instanceof TypeType)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.TypeConformanceTypeExp_ERROR_, this.getName(t.getType())));
            OCLPlugin.throwing(this.getClass(), "visitTypeExp", error);
            throw error;
        }
        if (t.getReferredType() == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.TypeExpMissingType_ERROR_, t.toString()));
            OCLPlugin.throwing(this.getClass(), "visitTypeExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitIntegerLiteralExp(IntegerLiteralExp<C> il) {
        if (il.getType() != this.getStandardLibrary().getInteger()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceIntegerLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitIntegerLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<C> unl) {
        if (unl.getType() != this.getStandardLibrary().getUnlimitedNatural()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceUnlimitedNaturalLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitUnlimitedNaturalLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitRealLiteralExp(RealLiteralExp<C> rl) {
        if (rl.getType() != this.getStandardLibrary().getReal()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceRealLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitRealLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitStringLiteralExp(StringLiteralExp<C> sl) {
        if (sl.getType() != this.getStandardLibrary().getString()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceStringLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitStringLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitBooleanLiteralExp(BooleanLiteralExp<C> bl) {
        if (bl.getType() != this.getStandardLibrary().getBoolean()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceBooleanLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitBooleanLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitLetExp(LetExp<C, PM> l) {
        Variable<C, PM> vd = l.getVariable();
        OCLExpression<C> in = l.getIn();
        Object type = l.getType();
        if (vd == null || in == null || type == null) {
            String message = OCLMessages.bind(OCLMessages.IncompleteLetExp_ERROR_, l.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitLetExp", error);
            throw error;
        }
        vd.accept(this);
        in.accept(this);
        if (TypeUtil.typeCompare(this.env, type, in.getType()) != 0) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceLetExp_ERROR_, type, in.getType());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitLetExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitIterateExp(IterateExp<C, PM> ie) {
        Variable<C, PM> vd = ie.getResult();
        Object type = ie.getType();
        OCLExpression body = ie.getBody();
        OCLExpression source = ie.getSource();
        List iterators = (List)ie.getIterator();
        if (vd == null || type == null || source == null || body == null || iterators.isEmpty()) {
            String message = OCLMessages.bind(OCLMessages.IncompleteIterateExp_ERROR_, ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
            throw error;
        }
        source.accept(this);
        vd.accept(this);
        body.accept(this);
        if (vd.getInitExpression() == null) {
            String message = OCLMessages.bind(OCLMessages.MissingInitIterateExp_ERROR_, ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
            throw error;
        }
        if (TypeUtil.typeCompare(this.env, type, vd.getType()) != 0) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceIterateExp_ERROR_, ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
            throw error;
        }
        if (TypeUtil.typeCompare(this.env, body.getType(), vd.getType()) > 0) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceIterateExpBody_ERROR_, ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
            throw error;
        }
        Object sourceType = source.getType();
        if (!(sourceType instanceof CollectionType)) {
            String message = OCLMessages.bind(OCLMessages.IteratorSource_ERROR_, ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
            throw error;
        }
        if (iterators.size() > 1) {
            String message = OCLMessages.bind(OCLMessages.TooManyIteratorVariables_ERROR_, ie.getName());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
            throw error;
        }
        for (Variable loopiter : iterators) {
            loopiter.accept(this);
            if (loopiter.getInitExpression() != null) {
                String message = OCLMessages.bind(OCLMessages.IterateExpLoopVarInit_ERROR_, ie.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
                throw error;
            }
            CollectionType ct = (CollectionType)sourceType;
            if (TypeUtil.typeCompare(this.env, loopiter.getType(), ct.getElementType()) == 0) continue;
            String message = OCLMessages.bind(OCLMessages.TypeConformanceIterateExpLoopVar_ERROR_, ie.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIterateExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitIteratorExp(IteratorExp<C, PM> ie) {
        IllegalArgumentException error;
        String message;
        Object type = ie.getType();
        OCLExpression body = ie.getBody();
        OCLExpression source = ie.getSource();
        List iterators = (List)ie.getIterator();
        String name = ie.getName();
        if (type == null || name == null || source == null || body == null || iterators.isEmpty()) {
            String message2 = OCLMessages.bind(OCLMessages.IncompleteIteratorExp_ERROR_, ie.toString());
            IllegalArgumentException error2 = new IllegalArgumentException(message2);
            OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error2);
            throw error2;
        }
        int opcode = 0;
        if (source.getType() instanceof PredefinedType) {
            opcode = OCLStandardLibraryUtil.getOperationCode(name);
        }
        source.accept(this);
        body.accept(this);
        switch (opcode) {
            case 201: 
            case 202: 
            case 203: {
                if (type == this.getStandardLibrary().getBoolean()) break;
                String message3 = OCLMessages.bind(OCLMessages.TypeConformanceIteratorResult_ERROR_, ie.toString());
                IllegalArgumentException error3 = new IllegalArgumentException(message3);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error3);
                throw error3;
            }
        }
        if (opcode == 206) {
            if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
                if (!(type instanceof SequenceType)) {
                    String message4 = OCLMessages.bind(OCLMessages.TypeConformanceCollectSequence_ERROR_, ie.toString());
                    IllegalArgumentException error4 = new IllegalArgumentException(message4);
                    OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error4);
                    throw error4;
                }
            } else if (!(type instanceof BagType)) {
                String message5 = OCLMessages.bind(OCLMessages.TypeConformanceCollectBag_ERROR_, ie.toString());
                IllegalArgumentException error5 = new IllegalArgumentException(message5);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error5);
                throw error5;
            }
        }
        switch (opcode) {
            case 209: 
            case 210: {
                if (TypeUtil.typeCompare(this.env, type, source.getType()) == 0) break;
                String message6 = OCLMessages.bind(OCLMessages.TypeConformanceSelectReject_ERROR_, ie.toString());
                IllegalArgumentException error6 = new IllegalArgumentException(message6);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error6);
                throw error6;
            }
        }
        switch (opcode) {
            case 201: 
            case 202: 
            case 204: 
            case 205: 
            case 209: 
            case 210: {
                if (body.getType() == this.getStandardLibrary().getBoolean()) break;
                String message7 = OCLMessages.bind(OCLMessages.TypeConformanceIteratorBodyBoolean_ERROR_, ie.toString());
                IllegalArgumentException error7 = new IllegalArgumentException(message7);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error7);
                throw error7;
            }
        }
        Object sourceType = source.getType();
        if (!(sourceType instanceof CollectionType)) {
            String message8 = OCLMessages.bind(OCLMessages.IteratorSource_ERROR_, ie.toString());
            IllegalArgumentException error8 = new IllegalArgumentException(message8);
            OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error8);
            throw error8;
        }
        if (opcode == 208) {
            Object bodyType;
            if (!(type instanceof SetType)) {
                String message9 = OCLMessages.bind(OCLMessages.TypeConformanceClosure_ERROR_, ie.toString());
                IllegalArgumentException error9 = new IllegalArgumentException(message9);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error9);
                throw error9;
            }
            CollectionType sourceCT = (CollectionType)source.getType();
            CollectionType bodyCT = (CollectionType)type;
            Object sourceElementType = sourceCT.getElementType();
            if (TypeUtil.typeCompare(this.env, sourceElementType, bodyType = bodyCT.getElementType()) < 0) {
                String message10 = OCLMessages.bind(OCLMessages.ElementTypeConformanceClosure_ERROR_, this.getName(bodyType), this.getName(sourceElementType));
                IllegalArgumentException error10 = new IllegalArgumentException(message10);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error10);
                throw error10;
            }
        }
        if (opcode == 211 && !this.uml.isComparable(body.getType())) {
            message = OCLMessages.bind(OCLMessages.OperationNotFound_ERROR_, "<", this.getName(body.getType()));
            error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
            throw error;
        }
        switch (opcode) {
            case 201: 
            case 202: {
                if (iterators.size() <= 2) break;
                message = OCLMessages.bind(OCLMessages.TooManyIteratorVariables_ERROR_, ie.getName());
                error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
                throw error;
            }
            default: {
                if (iterators.size() <= 1) break;
                message = OCLMessages.bind(OCLMessages.TooManyIteratorVariables_ERROR_, ie.getName());
                error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error);
                throw error;
            }
        }
        for (Variable loopiter : iterators) {
            loopiter.accept(this);
            if (loopiter.getInitExpression() != null) {
                String message11 = OCLMessages.bind(OCLMessages.IterateExpLoopVarInit_ERROR_, ie.toString());
                IllegalArgumentException error11 = new IllegalArgumentException(message11);
                OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error11);
                throw error11;
            }
            CollectionType ct = (CollectionType)sourceType;
            if (TypeUtil.typeCompare(this.env, loopiter.getType(), ct.getElementType()) == 0) continue;
            String message12 = OCLMessages.bind(OCLMessages.TypeConformanceIteratorExpLoopVar_ERROR_, ie.toString());
            IllegalArgumentException error12 = new IllegalArgumentException(message12);
            OCLPlugin.throwing(this.getClass(), "visitIteratorExp", error12);
            throw error12;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitCollectionLiteralExp(CollectionLiteralExp<C> cl) {
        CollectionKind kind = cl.getKind();
        Object type = cl.getType();
        if (!(type instanceof CollectionType)) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceCollectionLiteralExp_ERROR_, cl.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
            throw error;
        }
        switch (kind) {
            case SET_LITERAL: {
                if (type instanceof SetType) break;
                String message = OCLMessages.bind(OCLMessages.TypeConformanceSetLiteral_ERROR_, cl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
                throw error;
            }
            case ORDERED_SET_LITERAL: {
                if (type instanceof OrderedSetType) break;
                String message = OCLMessages.bind(OCLMessages.TypeConformanceOrderedSetLiteral_ERROR_, cl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
                throw error;
            }
            case BAG_LITERAL: {
                if (type instanceof BagType) break;
                String message = OCLMessages.bind(OCLMessages.TypeConformanceBagLiteral_ERROR_, cl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
                throw error;
            }
            default: {
                if (kind == CollectionKind.SEQUENCE_LITERAL && type instanceof SequenceType) break;
                String message = OCLMessages.bind(OCLMessages.TypeConformanceSequenceLiteral_ERROR_, cl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
                throw error;
            }
        }
        List parts = (List)cl.getPart();
        CollectionType collectionType = (CollectionType)type;
        if (parts.isEmpty()) {
            if (!(collectionType.getElementType() instanceof VoidType)) {
                String message = OCLMessages.bind(OCLMessages.TypeConformanceEmptyCollection_ERROR_, cl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
                throw error;
            }
            return Boolean.TRUE;
        }
        Object partsType = ((CollectionLiteralPart)parts.get(0)).getType();
        for (CollectionLiteralPart part : parts) {
            part.accept(this);
            try {
                partsType = TypeUtil.commonSuperType(this.env, partsType, part.getType());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        if (TypeUtil.typeCompare(this.env, partsType, collectionType.getElementType()) != 0) {
            String message = OCLMessages.bind(OCLMessages.TypeConformanceCollectionElementType_ERROR_, cl.toString());
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitCollectionLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitCollectionItem(CollectionItem<C> item) {
        return (Boolean)item.getItem().accept(this);
    }

    @Override
    public Boolean visitCollectionRange(CollectionRange<C> range) {
        if (((Boolean)range.getFirst().accept(this)).booleanValue() && ((Boolean)range.getLast().accept(this)).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitTupleLiteralExp(TupleLiteralExp<C, P> tl) {
        Object type = tl.getType();
        if (!(type instanceof TupleType)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.TypeConformanceTupleLiteralExp_ERROR_, tl.toString()));
            OCLPlugin.throwing(this.getClass(), "visitTupleLiteralExp", error);
            throw error;
        }
        List tp = (List)tl.getPart();
        if (tp.size() != this.uml.getAttributes(type).size()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.TypeConformanceTupleLiteralExpParts_ERROR_, tl.toString()));
            OCLPlugin.throwing(this.getClass(), "visitTupleLiteralExp", error);
            throw error;
        }
        HashSet<String> names = new HashSet<String>();
        for (TupleLiteralPart part : tl.getPart()) {
            String name = part.getName();
            P property = this.env.lookupProperty(type, name);
            if (property == null) {
                String message = OCLMessages.bind(OCLMessages.TupleLiteralExpressionPart_ERROR_, name, tl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitTupleLiteralExp", error);
                throw error;
            }
            if (!names.add(name)) {
                String message = OCLMessages.bind(OCLMessages.TupleDuplicateName_ERROR_, name, tl.toString());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitTupleLiteralExp", error);
                throw error;
            }
            part.accept(this);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitTupleLiteralPart(TupleLiteralPart<C, P> tp) {
        P property = tp.getAttribute();
        if (property == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.MissingPropertyInTupleLiteralPart_ERROR_, tp.getName(), tp.eContainer().toString()));
            OCLPlugin.throwing(this.getClass(), "visitTupleLiteralPart", error);
            throw error;
        }
        Object type = tp.getType();
        if (type == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.MissingTypeInTupleLiteralPart_ERROR_, tp.getName(), tp.eContainer().toString()));
            OCLPlugin.throwing(this.getClass(), "visitTupleLiteralPart", error);
            throw error;
        }
        if (TypeUtil.typeCompare(this.env, this.uml.getOCLType(property), type) != 0) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.TuplePartType_ERROR_, tp.getName(), tp.eContainer().toString()));
            OCLPlugin.throwing(this.getClass(), "visitTupleLiteralPart", error);
            throw error;
        }
        OCLExpression<C> value = tp.getValue();
        if (value != null) {
            value.accept(this);
            if (TypeUtil.typeCompare(this.env, value.getType(), type) > 0) {
                IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceTuplePartValue_ERROR_);
                OCLPlugin.throwing(this.getClass(), "visitTupleLiteralPart", error);
                throw error;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitStateExp(StateExp<C, S> s) {
        S state = s.getReferredState();
        if (state == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.bind(OCLMessages.MissingStateInStateExp_ERROR_, s.toString()));
            OCLPlugin.throwing(this.getClass(), "visitStateExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    private void visitFeatureCallExp(FeatureCallExp<C> exp) {
        OCLExpression source;
        if (exp.isMarkedPre() && !this.env.isInPostcondition(exp)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.AtPreInPostcondition_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitFeatureCallExp", error);
            throw error;
        }
        if (exp.getSource() != null && (source = exp.getSource()).getType() instanceof TypeType) {
            TypeType typeType = (TypeType)source.getType();
            Object feature = null;
            if (exp instanceof OperationCallExp) {
                feature = ((OperationCallExp)exp).getReferredOperation();
                if (!typeType.oclOperations().contains(feature) && !this.isStatic(feature)) {
                    String message = OCLMessages.bind(OCLMessages.NonStaticOperation_ERROR_, this.getName(feature));
                    IllegalArgumentException error = new IllegalArgumentException(message);
                    OCLPlugin.throwing(this.getClass(), "visitFeatureCallExp", error);
                }
            } else if (exp instanceof PropertyCallExp && !this.isStatic(feature = ((PropertyCallExp)exp).getReferredProperty())) {
                String message = OCLMessages.bind(OCLMessages.NonStaticAttribute_ERROR_, this.getName(feature));
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitFeatureCallExp", error);
            }
        }
    }

    private boolean isStatic(Object feature) {
        return this.uml != null && this.uml.isStatic(feature);
    }

    @Override
    public Boolean visitInvalidLiteralExp(InvalidLiteralExp<C> il) {
        if (!(il.getType() instanceof InvalidType)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceInvalidLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitInvalidLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitNullLiteralExp(NullLiteralExp<C> il) {
        if (!(il.getType() instanceof VoidType)) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.TypeConformanceNullLiteral_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitNullLiteralExp", error);
            throw error;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitExpressionInOCL(ExpressionInOCL<C, PM> expression) {
        if (expression.getContextVariable() == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.MissingContextVariable_ERROR_);
            OCLPlugin.throwing(this.getClass(), "visitExpressionInOCL", error);
            throw error;
        }
        CT constraint = this.uml.getConstraint(expression);
        if (constraint != null) {
            O operation = this.getConstrainedOperation(constraint);
            if (operation == null) {
                if (!expression.getParameterVariable().isEmpty()) {
                    IllegalArgumentException error = new IllegalArgumentException(OCLMessages.ExtraneousParameterVariables_ERROR_);
                    OCLPlugin.throwing(this.getClass(), "visitExpressionInOCL", error);
                    throw error;
                }
                if (expression.getResultVariable() != null) {
                    IllegalArgumentException error = new IllegalArgumentException(OCLMessages.ExtraneousResultVariable_ERROR_);
                    OCLPlugin.throwing(this.getClass(), "visitExpressionInOCL", error);
                    throw error;
                }
            } else {
                IllegalArgumentException error;
                List<PM> parameters = this.uml.getParameters(operation);
                List variables = (List)expression.getParameterVariable();
                if (parameters.size() != variables.size()) {
                    IllegalArgumentException error2 = new IllegalArgumentException(OCLMessages.MismatchedParameterVariables_ERROR_);
                    OCLPlugin.throwing(this.getClass(), "visitExpressionInOCL", error2);
                    throw error2;
                }
                Iterator<PM> iter = parameters.iterator();
                for (Variable var : expression.getParameterVariable()) {
                    PM param = iter.next();
                    var.accept(this);
                    C paramType = this.uml.getOCLType(param);
                    if (paramType == null || TypeUtil.typeCompare(this.env, paramType, var.getType()) == 0) continue;
                    IllegalArgumentException error3 = new IllegalArgumentException(OCLMessages.MismatchedParameterVariables_ERROR_);
                    OCLPlugin.throwing(this.getClass(), "visitExpressionInOCL", error3);
                    throw error3;
                }
                Variable<C, PM> resultVar = expression.getResultVariable();
                Object operType = null;
                String stereotype = this.uml.getStereotype(constraint);
                if (("body".equals(stereotype) || "postcondition".equals(stereotype)) && (operType = (Object)this.uml.getOCLType(operation)) instanceof VoidType) {
                    operType = null;
                }
                if (operType == null != (resultVar == null) && !"body".equals(stereotype)) {
                    error = resultVar == null ? new IllegalArgumentException(OCLMessages.MissingResultVariable_ERROR_) : new IllegalArgumentException(OCLMessages.ExtraneousResultVariable_ERROR_);
                    OCLPlugin.throwing(this.getClass(), "visitExpressionInOCL", error);
                    throw error;
                }
                if (resultVar != null) {
                    if (TypeUtil.typeCompare(this.env, operType, resultVar.getType()) != 0) {
                        error = new IllegalArgumentException(OCLMessages.MissingResultVariable_ERROR_);
                        OCLPlugin.throwing(this.getClass(), "visitExpressionInOCL", error);
                        throw error;
                    }
                    expression.getResultVariable().accept(this);
                }
            }
        }
        return (Boolean)expression.getBodyExpression().accept(this);
    }

    @Override
    public Boolean visitConstraint(CT constraint) {
        String message;
        String stereo = this.uml.getStereotype(constraint);
        ExpressionInOCL<C, PM> specification = this.uml.getSpecification(constraint);
        specification.accept(this);
        Object bodyType = specification.getBodyExpression().getType();
        C oclBoolean = this.getStandardLibrary().getBoolean();
        C operationType = null;
        Object propertyType = null;
        String operationName = null;
        String propertyName = null;
        String classifierName = null;
        if (!this.uml.getConstrainedElements(constraint).isEmpty()) {
            EObject constrained = this.uml.getConstrainedElements(constraint).get(0);
            if (this.uml.isOperation(constrained)) {
                operationName = this.getName(constrained);
                classifierName = this.getName(this.uml.getOwningClassifier(constrained));
                operationType = this.uml.getOCLType(constrained);
            } else if (this.uml.isProperty(constrained)) {
                propertyName = this.getName(constrained);
                classifierName = this.getName(this.uml.getOwningClassifier(constrained));
                propertyType = this.uml.getOCLType(constrained);
            } else if (this.uml.isClassifier(constrained)) {
                classifierName = this.getName(constrained);
            }
        }
        if (operationType == null) {
            operationType = this.env.getOCLStandardLibrary().getOclVoid();
        }
        if (propertyType == null) {
            propertyType = this.env.getOCLStandardLibrary().getOclVoid();
        }
        if ("postcondition".equals(stereo) || "precondition".equals(stereo)) {
            if (bodyType != oclBoolean) {
                message = OCLMessages.bind(OCLMessages.OperationConstraintBoolean_ERROR_, operationName);
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
                throw error;
            }
        } else if ("invariant".equals(stereo)) {
            if (bodyType != oclBoolean) {
                message = OCLMessages.bind(OCLMessages.InvariantConstraintBoolean_ERROR_, classifierName);
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
                throw error;
            }
        } else if ("definition".equals(stereo)) {
            EObject constrained;
            EObject feature = null;
            if (this.uml.getConstrainedElements(constraint).size() >= 2 && (this.uml.isOperation(constrained = this.uml.getConstrainedElements(constraint).get(1)) || this.uml.isProperty(constrained))) {
                feature = constrained;
            }
            if (feature == null) {
                String message2 = OCLMessages.bind(OCLMessages.DefinitionConstraintFeature_ERROR_, classifierName);
                IllegalArgumentException error = new IllegalArgumentException(message2);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
                throw error;
            }
            C featureType = this.uml.getOCLType(feature);
            if (featureType == null || TypeUtil.typeCompare(this.env, bodyType, featureType) > 0) {
                String message3 = OCLMessages.bind(OCLMessages.DefinitionConstraintConformance_ERROR_, this.getName(bodyType), this.getName(featureType));
                IllegalArgumentException error = new IllegalArgumentException(message3);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
                throw error;
            }
        } else if (("initial".equals(stereo) || "derivation".equals(stereo)) && TypeUtil.typeCompare(this.env, bodyType, propertyType) > 0) {
            message = OCLMessages.bind(OCLMessages.InitOrDerConstraintConformance_ERROR_, new Object[]{this.getName(bodyType), propertyName, this.getName(propertyType)});
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
            throw error;
        }
        if ("body".equals(this.uml.getStereotype(constraint))) {
            IllegalArgumentException error;
            if (operationType instanceof VoidType) {
                message = OCLMessages.bind(OCLMessages.BodyConditionNotAllowed_ERROR_, operationName);
                error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
                throw error;
            }
            if (bodyType == oclBoolean && operationType != oclBoolean) {
                this.visitBodyConditionConstraint(constraint, operationType, operationName);
            } else {
                if (TypeUtil.typeCompare(this.env, bodyType, operationType) > 0) {
                    message = OCLMessages.bind(OCLMessages.BodyConditionConformance_ERROR_, new Object[]{operationName, this.getName(bodyType), this.getName(operationType)});
                    error = new IllegalArgumentException(message);
                    OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
                    throw error;
                }
                if (this.findResultVariable(specification.getBodyExpression(), operationType)) {
                    message = OCLMessages.bind(OCLMessages.BodyConditionForm_ERROR_, operationName);
                    error = new IllegalArgumentException(message);
                    OCLPlugin.throwing(this.getClass(), "visitConstraint", error);
                    throw error;
                }
            }
        }
        return (Boolean)this.uml.getSpecification(constraint).getBodyExpression().accept(this);
    }

    private void visitBodyConditionConstraint(CT constraint, C operationType, String operationName) {
        OCLExpression bodyExpr;
        OCLExpression<C> exp = this.uml.getSpecification(constraint).getBodyExpression();
        while (exp instanceof LetExp) {
            exp = ((LetExp)exp).getIn();
        }
        OperationCallExp body = null;
        if (exp instanceof OperationCallExp) {
            body = (OperationCallExp)exp;
        }
        if (body == null || body.getOperationCode() != 60 || body.getArgument().size() != 1) {
            String message = OCLMessages.bind(OCLMessages.BodyConditionForm_ERROR_, operationName);
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitBodyConditionConstraint", error);
            throw error;
        }
        if (this.isResultVariable(body.getSource(), operationType)) {
            bodyExpr = (OCLExpression)body.getArgument().get(0);
        } else if (this.isResultVariable((OCLExpression)body.getArgument().get(0), operationType)) {
            bodyExpr = body.getSource();
        } else {
            String message = OCLMessages.bind(OCLMessages.BodyConditionForm_ERROR_, operationName);
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitBodyConditionConstraint", error);
            throw error;
        }
        Object bodyType = bodyExpr.getType();
        if ((TypeUtil.getRelationship(this.env, bodyType, operationType) & 3) == 0) {
            String message = OCLMessages.bind(OCLMessages.BodyConditionConformance_ERROR_, new Object[]{operationName, this.getName(bodyType), this.getName(operationType)});
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitBodyConditionConstraint", error);
            throw error;
        }
        if (this.findResultVariable(bodyExpr, operationType)) {
            String message = OCLMessages.bind(OCLMessages.BodyConditionForm_ERROR_, operationName);
            IllegalArgumentException error = new IllegalArgumentException(message);
            OCLPlugin.throwing(this.getClass(), "visitBodyConditionConstraint", error);
            throw error;
        }
    }

    private O getConstrainedOperation(CT constraint) {
        for (EObject constrained : this.uml.getConstrainedElements(constraint)) {
            if (!this.uml.isOperation(constrained)) continue;
            return (O)constrained;
        }
        return null;
    }

    String getName(Object element) {
        return element == null ? null : this.uml.getName(element);
    }

    private OCLStandardLibrary<C> getStandardLibrary() {
        return this.env.getOCLStandardLibrary();
    }

    private boolean isResultVariable(OCLExpression<C> expr, C expectedType) {
        boolean result = expr instanceof VariableExp;
        if (result) {
            try {
                result = TypeUtil.typeCompare(this.env, expr.getType(), expectedType) == 0;
            }
            catch (Exception exception) {
                result = false;
            }
        }
        if (result) {
            Variable var = ((VariableExp)expr).getReferredVariable();
            result = var != null && "result".equals(var.getName()) && var.eContainmentFeature() == UtilitiesPackage.Literals.EXPRESSION_IN_OCL__RESULT_VARIABLE;
        }
        return result;
    }

    private boolean findResultVariable(OCLExpression<C> expr, C expectedType) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ResultFinder
        extends AbstractVisitor<Variable<C, PM>, C, O, P, EL, PM, S, COA, SSA, CT> {
            boolean found = false;
            private final /* synthetic */ Object val$expectedType;

            ResultFinder(Object object) {
                this.val$expectedType = object;
            }

            @Override
            public Variable<C, PM> visitVariableExp(VariableExp<C, PM> v) {
                if (ValidationVisitor.this.isResultVariable(v, this.val$expectedType)) {
                    this.found = true;
                    return v.getReferredVariable();
                }
                return null;
            }
        }
        ResultFinder finder = new ResultFinder(expectedType);
        expr.accept(finder);
        return finder.found;
    }
}

