/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaNamedColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.mappings.DefaultFalseBoolean;
import org.eclipse.jpt.core.internal.mappings.DefaultTrueBoolean;
import org.eclipse.jpt.core.internal.mappings.IAbstractColumn;
import org.eclipse.jpt.core.internal.mappings.INamedColumn;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaColumn
extends JavaNamedColumn
implements IAbstractColumn {
    protected static final DefaultFalseBoolean UNIQUE_EDEFAULT = DefaultFalseBoolean.DEFAULT;
    protected DefaultFalseBoolean unique = UNIQUE_EDEFAULT;
    protected static final DefaultTrueBoolean NULLABLE_EDEFAULT = DefaultTrueBoolean.DEFAULT;
    protected DefaultTrueBoolean nullable = NULLABLE_EDEFAULT;
    protected static final DefaultTrueBoolean INSERTABLE_EDEFAULT = DefaultTrueBoolean.DEFAULT;
    protected DefaultTrueBoolean insertable = INSERTABLE_EDEFAULT;
    protected static final DefaultTrueBoolean UPDATABLE_EDEFAULT = DefaultTrueBoolean.DEFAULT;
    protected DefaultTrueBoolean updatable = UPDATABLE_EDEFAULT;
    protected static final String TABLE_EDEFAULT = null;
    protected static final String SPECIFIED_TABLE_EDEFAULT = null;
    protected String specifiedTable = SPECIFIED_TABLE_EDEFAULT;
    protected static final String DEFAULT_TABLE_EDEFAULT = null;
    protected String defaultTable = DEFAULT_TABLE_EDEFAULT;
    private final DeclarationAnnotationElementAdapter<String> tableDeclarationAdapter;
    private final AnnotationElementAdapter<String> tableAdapter;
    private final AnnotationElementAdapter<String> uniqueAdapter;
    private final AnnotationElementAdapter<String> nullableAdapter;
    private final AnnotationElementAdapter<String> insertableAdapter;
    private final AnnotationElementAdapter<String> updatableAdapter;

    protected AbstractJavaColumn() {
        throw new UnsupportedOperationException("Use AbstractJavaColumn(Owner, Member, DeclarationAnnotationAdapter) instead");
    }

    protected AbstractJavaColumn(INamedColumn.Owner owner, Member member, DeclarationAnnotationAdapter daa) {
        super(owner, member, daa);
        this.tableDeclarationAdapter = this.buildStringElementAdapter(this.tableElementName());
        this.tableAdapter = this.buildShortCircuitElementAdapter(this.tableDeclarationAdapter);
        this.uniqueAdapter = this.buildShortCircuitBooleanElementAdapter(this.uniqueElementName());
        this.nullableAdapter = this.buildShortCircuitBooleanElementAdapter(this.nullableElementName());
        this.insertableAdapter = this.buildShortCircuitBooleanElementAdapter(this.insertableElementName());
        this.updatableAdapter = this.buildShortCircuitBooleanElementAdapter(this.updatableElementName());
    }

    protected abstract String tableElementName();

    protected abstract String uniqueElementName();

    protected abstract String nullableElementName();

    protected abstract String insertableElementName();

    protected abstract String updatableElementName();

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IAbstractColumn.class)) {
            case 9: {
                this.tableAdapter.setValue((String)notification.getNewValue());
                break;
            }
            case 4: {
                this.uniqueAdapter.setValue(((DefaultFalseBoolean)((Object)notification.getNewValue())).convertToJavaAnnotationValue());
                break;
            }
            case 5: {
                this.nullableAdapter.setValue(((DefaultTrueBoolean)((Object)notification.getNewValue())).convertToJavaAnnotationValue());
                break;
            }
            case 6: {
                this.insertableAdapter.setValue(((DefaultTrueBoolean)((Object)notification.getNewValue())).convertToJavaAnnotationValue());
                break;
            }
            case 7: {
                this.updatableAdapter.setValue(((DefaultTrueBoolean)((Object)notification.getNewValue())).convertToJavaAnnotationValue());
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.ABSTRACT_JAVA_COLUMN;
    }

    @Override
    public DefaultFalseBoolean getUnique() {
        return this.unique;
    }

    @Override
    public void setUnique(DefaultFalseBoolean newUnique) {
        DefaultFalseBoolean oldUnique = this.unique;
        DefaultFalseBoolean defaultFalseBoolean = this.unique = newUnique == null ? UNIQUE_EDEFAULT : newUnique;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldUnique, (Object)this.unique));
        }
    }

    @Override
    public DefaultTrueBoolean getNullable() {
        return this.nullable;
    }

    @Override
    public void setNullable(DefaultTrueBoolean newNullable) {
        DefaultTrueBoolean oldNullable = this.nullable;
        DefaultTrueBoolean defaultTrueBoolean = this.nullable = newNullable == null ? NULLABLE_EDEFAULT : newNullable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldNullable, (Object)this.nullable));
        }
    }

    @Override
    public DefaultTrueBoolean getInsertable() {
        return this.insertable;
    }

    @Override
    public void setInsertable(DefaultTrueBoolean newInsertable) {
        DefaultTrueBoolean oldInsertable = this.insertable;
        DefaultTrueBoolean defaultTrueBoolean = this.insertable = newInsertable == null ? INSERTABLE_EDEFAULT : newInsertable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldInsertable, (Object)this.insertable));
        }
    }

    @Override
    public DefaultTrueBoolean getUpdatable() {
        return this.updatable;
    }

    @Override
    public void setUpdatable(DefaultTrueBoolean newUpdatable) {
        DefaultTrueBoolean oldUpdatable = this.updatable;
        DefaultTrueBoolean defaultTrueBoolean = this.updatable = newUpdatable == null ? UPDATABLE_EDEFAULT : newUpdatable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldUpdatable, (Object)this.updatable));
        }
    }

    @Override
    public String getTable() {
        return this.getSpecifiedTable() == null ? this.getDefaultTable() : this.getSpecifiedTable();
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldSpecifiedTable, (Object)this.specifiedTable));
        }
    }

    protected void setDefaultTable(String newDefaultTable) {
        String oldDefaultTable = this.defaultTable;
        this.defaultTable = newDefaultTable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldDefaultTable, (Object)newDefaultTable));
        }
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                return this.getUnique();
            }
            case 5: {
                return this.getNullable();
            }
            case 6: {
                return this.getInsertable();
            }
            case 7: {
                return this.getUpdatable();
            }
            case 8: {
                return this.getTable();
            }
            case 9: {
                return this.getSpecifiedTable();
            }
            case 10: {
                return this.getDefaultTable();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setUnique((DefaultFalseBoolean)((Object)newValue));
                return;
            }
            case 5: {
                this.setNullable((DefaultTrueBoolean)((Object)newValue));
                return;
            }
            case 6: {
                this.setInsertable((DefaultTrueBoolean)((Object)newValue));
                return;
            }
            case 7: {
                this.setUpdatable((DefaultTrueBoolean)((Object)newValue));
                return;
            }
            case 9: {
                this.setSpecifiedTable((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.setUnique(UNIQUE_EDEFAULT);
                return;
            }
            case 5: {
                this.setNullable(NULLABLE_EDEFAULT);
                return;
            }
            case 6: {
                this.setInsertable(INSERTABLE_EDEFAULT);
                return;
            }
            case 7: {
                this.setUpdatable(UPDATABLE_EDEFAULT);
                return;
            }
            case 9: {
                this.setSpecifiedTable(SPECIFIED_TABLE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return this.unique != UNIQUE_EDEFAULT;
            }
            case 5: {
                return this.nullable != NULLABLE_EDEFAULT;
            }
            case 6: {
                return this.insertable != INSERTABLE_EDEFAULT;
            }
            case 7: {
                return this.updatable != UPDATABLE_EDEFAULT;
            }
            case 8: {
                return TABLE_EDEFAULT == null ? this.getTable() != null : !TABLE_EDEFAULT.equals(this.getTable());
            }
            case 9: {
                return SPECIFIED_TABLE_EDEFAULT == null ? this.specifiedTable != null : !SPECIFIED_TABLE_EDEFAULT.equals(this.specifiedTable);
            }
            case 10: {
                return DEFAULT_TABLE_EDEFAULT == null ? this.defaultTable != null : !DEFAULT_TABLE_EDEFAULT.equals(this.defaultTable);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IAbstractColumn.class) {
            switch (derivedFeatureID) {
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 9: {
                    return 9;
                }
                case 10: {
                    return 10;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IAbstractColumn.class) {
            switch (baseFeatureID) {
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 9: {
                    return 9;
                }
                case 10: {
                    return 10;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (unique: ");
        result.append((Object)this.unique);
        result.append(", nullable: ");
        result.append((Object)this.nullable);
        result.append(", insertable: ");
        result.append((Object)this.insertable);
        result.append(", updatable: ");
        result.append((Object)this.updatable);
        result.append(", specifiedTable: ");
        result.append(this.specifiedTable);
        result.append(", defaultTable: ");
        result.append(this.defaultTable);
        result.append(')');
        return result.toString();
    }

    @Override
    protected String tableName() {
        return this.getTable();
    }

    @Override
    public ITextRange tableTextRange() {
        return this.elementTextRange(this.tableDeclarationAdapter);
    }

    public boolean tableTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.tableDeclarationAdapter, pos, astRoot);
    }

    private Iterator<String> candidateTableNames() {
        return this.tableIsAllowed() ? this.getOwner().getTypeMapping().associatedTableNamesIncludingInherited() : EmptyIterator.instance();
    }

    private Iterator<String> candidateTableNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateTableNames(), filter);
    }

    private Iterator<String> quotedCandidateTableNames(Filter<String> filter) {
        return StringTools.quote(this.candidateTableNames(filter));
    }

    public abstract boolean tableIsAllowed();

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.tableTouches(pos, astRoot)) {
            return this.quotedCandidateTableNames(filter);
        }
        return null;
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setSpecifiedTable(this.tableAdapter.getValue(astRoot));
        this.setUnique(DefaultFalseBoolean.fromJavaAnnotationValue(this.uniqueAdapter.getValue(astRoot)));
        this.setNullable(DefaultTrueBoolean.fromJavaAnnotationValue(this.nullableAdapter.getValue(astRoot)));
        this.setInsertable(DefaultTrueBoolean.fromJavaAnnotationValue(this.insertableAdapter.getValue(astRoot)));
        this.setUpdatable(DefaultTrueBoolean.fromJavaAnnotationValue(this.updatableAdapter.getValue(astRoot)));
    }
}

