/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaSingleRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.ISingleRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContextWrapper;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaRelationshipMappingContext;
import org.eclipse.jpt.core.internal.platform.JoinColumnContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaSingleRelationshipMappingContext
extends JavaRelationshipMappingContext {
    private Collection<JoinColumnContext> joinColumnContexts = this.buildJoinColumnContexts();

    protected JavaSingleRelationshipMappingContext(IContext parentContext, JavaSingleRelationshipMapping mapping) {
        super(parentContext, mapping);
    }

    protected Collection<JoinColumnContext> buildJoinColumnContexts() {
        ArrayList<JoinColumnContext> contexts = new ArrayList<JoinColumnContext>();
        for (IJoinColumn column : this.getMapping().getJoinColumns()) {
            contexts.add(new JoinColumnContext((IContext)this, column));
        }
        return contexts;
    }

    @Override
    protected ISingleRelationshipMapping getMapping() {
        return (ISingleRelationshipMapping)super.getMapping();
    }

    protected ITable getTable() {
        IEntity entity = this.getMapping().getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getTable();
    }

    @Override
    protected void refreshDefaultsInternal(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        super.refreshDefaultsInternal(defaultsContext, monitor);
        DefaultsContext joinColumnsDefaultsContext = this.wrapDefaultsContextForJoinColumn(defaultsContext);
        for (JoinColumnContext context : this.joinColumnContexts) {
            context.refreshDefaults(joinColumnsDefaultsContext, monitor);
        }
    }

    protected DefaultsContext wrapDefaultsContextForJoinColumn(DefaultsContext defaultsContext) {
        return new DefaultsContextWrapper(defaultsContext){

            public Object getDefault(String key) {
                if (key.equals("joinColumn.table")) {
                    ITable table = JavaSingleRelationshipMappingContext.this.getTable();
                    if (table == null) {
                        return null;
                    }
                    return table.getName();
                }
                return super.getDefault(key);
            }
        };
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.entityOwned() && this.isOwningSide()) {
            this.addJoinColumnMessages(messages);
        }
    }

    protected abstract boolean isOwningSide();

    protected void addJoinColumnMessages(List<IMessage> messages) {
        ISingleRelationshipMapping mapping = this.getMapping();
        ITypeMapping typeMapping = mapping.typeMapping();
        for (IJoinColumn joinColumn : mapping.getJoinColumns()) {
            String table = joinColumn.getTable();
            boolean doContinue = joinColumn.isConnected();
            if (doContinue && typeMapping.tableNameIsInvalid(table)) {
                messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{table, joinColumn.getName()}, joinColumn, joinColumn.tableTextRange()));
                doContinue = false;
            }
            if (doContinue && !joinColumn.isResolved()) {
                messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.nameTextRange()));
            }
            if (!doContinue || joinColumn.isReferencedColumnResolved()) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.referencedColumnNameTextRange()));
        }
    }
}

