/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.content.orm.XmlOneToOne;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.INonOwningMapping;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.XmlSingleRelationshipMappingContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlOneToOneContext
extends XmlSingleRelationshipMappingContext {
    public XmlOneToOneContext(IContext parentContext, XmlOneToOne mapping) {
        super(parentContext, mapping);
    }

    protected XmlOneToOne getMapping() {
        return (XmlOneToOne)super.attributeMapping();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.getMapping().getMappedBy() != null) {
            this.addMappedByMessages(messages);
        }
    }

    protected void addMappedByMessages(List<IMessage> messages) {
        INonOwningMapping mappedByMapping;
        XmlOneToOne mapping = this.getMapping();
        String mappedBy = mapping.getMappedBy();
        IEntity targetEntity = mapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        IPersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(mappedBy);
        if (attribute == null) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{mappedBy}, mapping, mapping.mappedByTextRange()));
            return;
        }
        if (!mapping.mappedByIsValid(attribute.getMapping())) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{mappedBy}, mapping, mapping.mappedByTextRange()));
            return;
        }
        try {
            mappedByMapping = (INonOwningMapping)attribute.getMapping();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (mappedByMapping.getMappedBy() != null) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", mapping, mapping.mappedByTextRange()));
        }
    }

    @Override
    protected boolean isOwningSide() {
        return this.getMapping().getMappedBy() == null;
    }
}

