/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.application.internal.operations.CopyArchiveIntoProjectOperation;
import org.eclipse.jst.j2ee.application.internal.operations.CreateProjectWithExtractedJarOperation;
import org.eclipse.jst.j2ee.application.internal.operations.CreateProjectWithLinkedJarOperation;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEUtilityJarImportAssistantOperation;
import org.eclipse.jst.j2ee.application.internal.operations.LinkArchiveIntoProjectOperation;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class J2EEUtilityJarListImportOperation
extends AbstractDataModelOperation
implements IUndoableOperation {
    private static final int ASSISTANT_TICKS = 5;

    public J2EEUtilityJarListImportOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        MultiStatus status = new MultiStatus("org.eclipse.jst.j2ee", 0, EARCreationResourceHandler.J2EEUtilityJarListImportOperation_UI_Import_Utility_Jars, null);
        Object[] utilityJars = (Object[])this.model.getProperty("J2EEUtilityJarListImportDataModel.UTILITY_JAR_LIST");
        if (utilityJars == null || utilityJars.length == 0) {
            return J2EEPlugin.createErrorStatus(0, EARCreationResourceHandler.J2EEUtilityJarListImportOperation_There_were_no_utility_jars_selected, null);
        }
        monitor.beginTask(EARCreationResourceHandler.J2EEUtilityJarListImportOperation_UI_Import_Utility_Jars, utilityJars.length * 6);
        boolean toLinkImportedJars = this.shouldLinkImportedJars();
        boolean toCreateProject = this.shouldCreateProject();
        boolean toOverrideProjectRoot = this.shouldOverrideProjectRoot();
        boolean toOverwriteIfNecessary = this.shouldOverwriteIfNecessary();
        String projectRoot = null;
        if (toOverrideProjectRoot) {
            projectRoot = this.model.getStringProperty("J2EEUtilityJarListImportDataModel.PROJECT_ROOT");
        }
        monitor.subTask(EARCreationResourceHandler.J2EEUtilityJarListImportOperation_UI_Preparing_to_import);
        String associatedEARProjectName = this.model.getStringProperty("J2EEUtilityJarImportDataModel.EAR_PROJECT_NAME");
        J2EEUtilityJarImportAssistantOperation assistantOperation = null;
        ArrayList<J2EEUtilityJarImportAssistantOperation> utilityJarOperations = new ArrayList<J2EEUtilityJarImportAssistantOperation>();
        File utilityJar = null;
        String linkedPathVariable = null;
        if (this.model.isPropertySet("J2EEUtilityJarListImportDataModel.LINKED_PATH_VARIABLE")) {
            linkedPathVariable = this.model.getStringProperty("J2EEUtilityJarListImportDataModel.LINKED_PATH_VARIABLE");
        }
        int i = 0;
        while (i < utilityJars.length && !monitor.isCanceled()) {
            utilityJar = (File)utilityJars[i];
            assistantOperation = toCreateProject ? (!toLinkImportedJars ? new CreateProjectWithExtractedJarOperation(utilityJar, projectRoot) : new CreateProjectWithLinkedJarOperation(utilityJar, projectRoot, linkedPathVariable)) : (!toLinkImportedJars ? new CopyArchiveIntoProjectOperation(utilityJar) : new LinkArchiveIntoProjectOperation(utilityJar, linkedPathVariable));
            assistantOperation.setAssociatedEARProjectName(associatedEARProjectName);
            assistantOperation.setOverwriteIfNecessary(toOverwriteIfNecessary);
            utilityJarOperations.add(assistantOperation);
            monitor.worked(1);
            ++i;
        }
        Iterator iter = utilityJarOperations.iterator();
        while (iter.hasNext() && !monitor.isCanceled()) {
            try {
                assistantOperation = (J2EEUtilityJarImportAssistantOperation)((Object)iter.next());
                SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 5);
                assistantOperation.execute((IProgressMonitor)submonitor, null);
                submonitor.done();
            }
            catch (Exception e) {
                status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
                J2EEPlugin.logError(0, e.getMessage(), e);
            }
        }
        monitor.done();
        return status;
    }

    private boolean shouldOverwriteIfNecessary() {
        return this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.OVERWRITE_IF_NECESSARY");
    }

    protected final boolean shouldImportAsBinary() {
        return this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.BINARY_IMPORT");
    }

    protected final boolean shouldOverrideProjectRoot() {
        return this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.OVERRIDE_PROJECT_ROOT");
    }

    protected final boolean shouldCreateProject() {
        return this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.CREATE_PROJECT") || this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.CREATE_LINKED_PROJECT");
    }

    protected final boolean shouldLinkImportedJars() {
        return this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.LINK_IMPORT") || this.model.getBooleanProperty("J2EEUtilityJarListImportDataModel.CREATE_LINKED_PROJECT");
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }
}

