/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.mappings.IAssociationOverride;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnDialog;
import org.eclipse.swt.widgets.Shell;

public class JoinColumnInAssociationOverrideDialog
extends JoinColumnDialog {
    private IAssociationOverride associationOverride;

    JoinColumnInAssociationOverrideDialog(Shell parent, IAssociationOverride associationOverride) {
        super(parent);
        this.associationOverride = associationOverride;
    }

    JoinColumnInAssociationOverrideDialog(Shell parent, IJoinColumn joinColumn) {
        super(parent, joinColumn);
        this.associationOverride = (IAssociationOverride)joinColumn.eContainer();
    }

    protected Schema getSchema() {
        return this.associationOverride.typeMapping().dbSchema();
    }

    protected String defaultTableName() {
        if (this.getJoinColumn() != null) {
            return ((IJoinColumn)this.getJoinColumn()).getDefaultTable();
        }
        return this.associationOverride.typeMapping().getTableName();
    }

    protected Table getNameTable() {
        return this.associationOverride.typeMapping().primaryDbTable();
    }

    protected Table getReferencedNameTable() {
        IAttributeMapping attributeMapping = this.associationOverride.getOwner().attributeMapping(this.associationOverride.getName());
        if (attributeMapping == null || !(attributeMapping instanceof IRelationshipMapping)) {
            return null;
        }
        IEntity targetEntity = ((IRelationshipMapping)attributeMapping).getResolvedTargetEntity();
        if (targetEntity != null) {
            return targetEntity.primaryDbTable();
        }
        return null;
    }
}

