/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;

public class RAMOutputStream
extends BufferedIndexOutput {
    private RAMFile file;
    private int pointer = 0;

    public RAMOutputStream() {
        this(new RAMFile());
    }

    RAMOutputStream(RAMFile f) {
        this.file = f;
    }

    public void writeTo(IndexOutput out) throws IOException {
        this.flush();
        long end = this.file.length;
        long pos = 0L;
        int buffer = 0;
        while (pos < end) {
            int length = 1024;
            long nextPos = pos + (long)length;
            if (nextPos > end) {
                length = (int)(end - pos);
            }
            out.writeBytes((byte[])this.file.buffers.elementAt(buffer++), length);
            pos = nextPos;
        }
    }

    public void reset() {
        try {
            this.seek(0L);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        this.file.length = 0L;
    }

    public void flushBuffer(byte[] src, int len) {
        int bufferPos = 0;
        while (bufferPos != len) {
            byte[] buffer;
            int bytesToCopy;
            int bufferNumber = this.pointer / 1024;
            int bufferOffset = this.pointer % 1024;
            int bytesInBuffer = 1024 - bufferOffset;
            int remainInSrcBuffer = len - bufferPos;
            int n = bytesToCopy = bytesInBuffer >= remainInSrcBuffer ? remainInSrcBuffer : bytesInBuffer;
            if (bufferNumber == this.file.buffers.size()) {
                buffer = new byte[1024];
                this.file.buffers.addElement(buffer);
            } else {
                buffer = (byte[])this.file.buffers.elementAt(bufferNumber);
            }
            System.arraycopy(src, bufferPos, buffer, bufferOffset, bytesToCopy);
            bufferPos += bytesToCopy;
            this.pointer += bytesToCopy;
        }
        if ((long)this.pointer > this.file.length) {
            this.file.length = this.pointer;
        }
        this.file.lastModified = System.currentTimeMillis();
    }

    public void close() throws IOException {
        super.close();
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.pointer = (int)pos;
    }

    public long length() {
        return this.file.length;
    }
}

