/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.stp.ui.xef.editor.IXefDetailsPage;
import org.eclipse.stp.ui.xef.editor.XefEditMasterDetailsBlock;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.ui.forms.IDetailsPage;
import org.jdom.Attribute;
import org.jdom.Element;

public class ChangePrefixAction
extends Action {
    private final XefEditMasterDetailsBlock block;
    String nonInteractiveNewValue = null;

    ChangePrefixAction(XefEditMasterDetailsBlock b) {
        super("Change Prefix");
        this.block = b;
    }

    public void run() {
        XMLInstanceElement ie = this.block.getSelectedPolicyInstanceElement();
        if (ie == null) {
            return;
        }
        InputDialog dlg = new InputDialog(this.block.getViewer().getControl().getShell(), "Change Prefix", "Please enter the new Name Space prefix to use", ie.getNamespacePrefix(), (IInputValidator)new NameSpacePrefixInputValidator());
        String newNS = null;
        if (this.nonInteractiveNewValue != null) {
            newNS = this.nonInteractiveNewValue;
            this.nonInteractiveNewValue = null;
        } else if (dlg.open() == 0) {
            newNS = dlg.getValue();
        }
        if (newNS != null) {
            this.changePrefix(newNS, ie);
        }
    }

    void changePrefix(String newPrefix, XMLInstanceElement ie) {
        Element el = ie.getJDOMElement();
        Element newEl = new Element(el.getName(), newPrefix, el.getNamespaceURI());
        for (Attribute attr : new ArrayList(el.getAttributes())) {
            newEl.setAttribute(attr.detach());
        }
        newEl.addContent((Collection)el.cloneContent());
        ie.setJDOMElement(newEl);
        XefEditMasterDetailsBlock.policyLabels.put(ie, ie.toString());
        this.block.getViewer().refresh((Object)ie);
        IDetailsPage details = this.block.getDetailsPart().getCurrentPage();
        if (details instanceof IXefDetailsPage) {
            ((IXefDetailsPage)details).setDirty(true);
        }
    }

    static class NameSpacePrefixInputValidator
    implements IInputValidator {
        NameSpacePrefixInputValidator() {
        }

        public String isValid(String newText) {
            if (newText.length() == 0) {
                return "The prefix cannot be empty";
            }
            if (newText.matches("(.*)\\s(.*)")) {
                return "The name space prefix cannot contain spaces";
            }
            if (newText.matches("(.*)[^a-z0-9](.*)")) {
                return "The name space prefix can only contain lowercase alphanumeric characters";
            }
            return null;
        }
    }
}

