/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.stp.ui.xef.editor.XMLEditPage;
import org.eclipse.stp.ui.xef.editor.XMLProviderEditorInput;
import org.eclipse.stp.ui.xef.editor.XefEditPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;

public class XefEditor
extends FormEditor {
    XefEditPage policyEditPage;
    XMLEditPage xmlEditPage;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof XMLProviderEditorInput) {
            this.setPartName(((XMLProviderEditorInput)input).getTitle());
        }
    }

    protected void addPages() {
        try {
            this.policyEditPage = new XefEditPage(this, "policy", "Policy");
            this.addPage(this.policyEditPage);
            this.xmlEditPage = new XMLEditPage(this, "xml", "XML");
            this.addPage((IEditorPart)this.xmlEditPage, this.getEditorInput());
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    void fireSaveNeeded(IEditorInput input, boolean notify) {
        if (notify) {
            this.editorDirtyStateChanged();
        }
        this.isDirty();
    }

    void fireSaveNeeded() {
        this.editorDirtyStateChanged();
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.synchronizeModelAndText()) {
            return;
        }
        this.xmlEditPage.doSave(monitor);
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof XMLProviderEditorInput) {
            try {
                ((XMLProviderEditorInput)editorInput).propagate();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.policyEditPage.clearDirty();
        this.firePropertyChange(1);
    }

    private boolean synchronizeModelAndText() {
        if (this.getActivePageInstance() == this.policyEditPage && this.isDirty()) {
            if (!this.policyEditPage.block.validate()) {
                return false;
            }
            this.policyEditPage.getManagedForm().commit(true);
            this.xmlEditPage.syncFromModel();
        }
        return true;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

