/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.schema;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.eclipse.stp.ui.xef.schema.AbstractAnnotatedElement;
import org.eclipse.stp.ui.xef.schema.AnnotatedElement;
import org.eclipse.stp.ui.xef.schema.AnyElement;
import org.eclipse.stp.ui.xef.schema.SchemaAttribute;
import org.eclipse.stp.ui.xef.schema.WidgetType;
import org.eclipse.stp.xef.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaElement
extends AbstractAnnotatedElement
implements AnnotatedElement,
Comparable {
    final XSElementDeclaration ctx;
    final XSParticle particle;
    final XSModelGroup group;
    private AnyElement anySequenceElement;

    SchemaElement(XSElementDeclaration obj, XSParticle part, XSModelGroup grp) {
        this.ctx = obj;
        this.particle = part;
        this.group = grp;
        this.handleAnnotations(this.ctx.getAnnotation());
    }

    @Override
    public String getDisplayName() {
        return this.getDisplayName(false);
    }

    public String getDisplayName(boolean isMenu) {
        String dn = super.getDisplayName();
        if (dn == null) {
            dn = !isMenu && this.ctx.getScope() == 1 ? this.toRawString() : this.getName();
        }
        return dn;
    }

    public String getName() {
        return this.ctx.getName();
    }

    public String getShortNameSpace() {
        return XMLUtil.inferNamespacePrefix(this.ctx.getNamespace());
    }

    public String getNameSpace() {
        return this.ctx.getNamespace();
    }

    public Map<String, Boolean> getQualifiers() {
        return this.qualifiers;
    }

    public List<List<String>> getRequires() {
        return this.requires;
    }

    public List<SchemaAttribute> getAttributes() {
        LinkedList<SchemaAttribute> l = new LinkedList<SchemaAttribute>();
        XSTypeDefinition td = this.ctx.getTypeDefinition();
        if (td instanceof XSComplexTypeDefinition) {
            XSComplexTypeDefinition ctd = (XSComplexTypeDefinition)td;
            XSObjectList attrs = ctd.getAttributeUses();
            int i = 0;
            while (i < attrs.getLength()) {
                XSObject obj = attrs.item(i);
                if (obj instanceof XSAttributeUse) {
                    XSAttributeUse attr = (XSAttributeUse)obj;
                    SchemaAttribute sa = new SchemaAttribute(attr.getAttrDeclaration());
                    sa.setRequired(attr.getRequired());
                    if (attr.getConstraintType() == 1) {
                        sa.setDefault(attr.getConstraintValue());
                    }
                    if (attr.getConstraintType() == 2) {
                        sa.setFixed(attr.getConstraintValue());
                    }
                    this.handleAttributeAnnotations(attr, sa);
                    l.add(sa);
                }
                ++i;
            }
        }
        return l;
    }

    private void handleAttributeAnnotations(XSAttributeUse attr, SchemaAttribute sa) {
        XSAnnotation annotation = attr.getAttrDeclaration().getAnnotation();
        if (annotation != null) {
            NodeList contextElems;
            DocumentImpl domDoc = new DocumentImpl();
            annotation.writeAnnotation((Object)domDoc, (short)3);
            NodeList docNodes = domDoc.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "documentation");
            sa.setDocumentation(SchemaElement.getI18nTextValue(docNodes));
            sa.setCategory(SchemaElement.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "category")));
            sa.setDisplayName(SchemaElement.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "displayName")));
            sa.setDocShort(SchemaElement.getI18nTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "docShort")));
            sa.setExample(SchemaElement.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "example")));
            sa.setFilterId(SchemaElement.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "filter")));
            sa.setFieldEditorId(SchemaElement.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "fieldEditor")));
            sa.setPattern(SchemaElement.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "pattern")));
            sa.setUnits(SchemaElement.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "units")));
            String widgetType = SchemaElement.getTextValue(domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef/gui", "widget"));
            if (widgetType != null) {
                try {
                    sa.setWidget(WidgetType.valueOf(widgetType.toUpperCase()));
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
            if ((contextElems = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef/gui", "context")).getLength() > 0 && contextElems.item(0) instanceof Element) {
                String contextXPath;
                String contextType = SchemaElement.getTextValue(((Element)contextElems.item(0)).getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef/gui", "values"));
                if (contextType != null) {
                    sa.setContextValueID(contextType);
                }
                if ((contextXPath = SchemaElement.getTextValue(((Element)contextElems.item(0)).getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef/gui", "dependency"))) != null) {
                    sa.setContextXPath(contextXPath);
                }
            }
        }
    }

    public SchemaAttribute getAttribute(String name) {
        for (SchemaAttribute attr : this.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public boolean hasText() {
        XSTypeDefinition type = this.ctx.getTypeDefinition();
        if (type instanceof XSComplexTypeDefinition) {
            return ((XSComplexTypeDefinition)type).getContentType() == 3;
        }
        return false;
    }

    public SchemaElement getNestedElement(String name) {
        for (SchemaElement nested : this.getNestedElements(new LinkedList<SchemaElement>())) {
            if (!nested.getName().equals(name)) continue;
            return nested;
        }
        return null;
    }

    public List<SchemaElement> getNestedElements(List<SchemaElement> present) {
        XSTerm groupTerm;
        XSComplexTypeDefinition ctd;
        XSParticle part;
        XSTypeDefinition td = this.ctx.getTypeDefinition();
        if (td instanceof XSComplexTypeDefinition && (part = (ctd = (XSComplexTypeDefinition)td).getParticle()) != null && (groupTerm = part.getTerm()) instanceof XSModelGroup) {
            return this.getNestedElements((XSModelGroup)groupTerm, present);
        }
        return new ArrayList<SchemaElement>(0);
    }

    public List<SchemaElement> getMinimalSisterElementsList(List<SchemaElement> present) {
        LinkedList<SchemaElement> ret = new LinkedList<SchemaElement>();
        if (this.group != null) {
            switch (this.group.getCompositor()) {
                case 1: 
                case 3: {
                    List<SchemaElement> sisters = this.getElements(this.group);
                    for (SchemaElement sister : sisters) {
                        if (sister.equals(this) || sister.particle == null) continue;
                        int pCount = sister.particle.getMinOccurs();
                        for (SchemaElement p : present) {
                            if (!p.equals(sister)) continue;
                            --pCount;
                        }
                        while (pCount > 0) {
                            ret.add(sister);
                            --pCount;
                        }
                    }
                    break;
                }
            }
        }
        return ret;
    }

    public List<SchemaElement> getMinimalSubElementList() {
        XSTerm groupTerm;
        XSComplexTypeDefinition ctd;
        XSParticle particle;
        XSTypeDefinition td = this.ctx.getTypeDefinition();
        if (td instanceof XSComplexTypeDefinition && (particle = (ctd = (XSComplexTypeDefinition)td).getParticle()) != null && (groupTerm = particle.getTerm()) instanceof XSModelGroup) {
            XSModelGroup group = (XSModelGroup)groupTerm;
            switch (group.getCompositor()) {
                case 1: 
                case 3: {
                    List<SchemaElement> availableElements = this.getElements(group);
                    LinkedList<SchemaElement> minimalElements = new LinkedList<SchemaElement>();
                    for (SchemaElement available : availableElements) {
                        if (available.particle == null) continue;
                        int i = 0;
                        while (i < available.particle.getMinOccurs()) {
                            minimalElements.add(available);
                            ++i;
                        }
                    }
                    return minimalElements;
                }
            }
            return new ArrayList<SchemaElement>(0);
        }
        return new ArrayList<SchemaElement>(0);
    }

    private List<SchemaElement> getNestedElements(XSModelGroup group, List<SchemaElement> present) {
        ArrayList<SchemaElement> ret = new ArrayList<SchemaElement>();
        List<SchemaElement> availableElements = this.getElements(group);
        List<XSModelGroup> subGroups = this.getSubGroups(group);
        switch (group.getCompositor()) {
            case 2: {
                ret.addAll(this.getChoiceElements(availableElements, subGroups, present));
                break;
            }
            case 1: {
                ret.addAll(this.getSequenceElements(availableElements, present));
                break;
            }
            case 3: {
                ret.addAll(availableElements);
                break;
            }
        }
        for (XSModelGroup subGroup : subGroups) {
            ret.addAll(this.getNestedElements(subGroup, present));
        }
        return ret;
    }

    private List<SchemaElement> getChoiceElements(List<SchemaElement> availableElements, List<XSModelGroup> subGroups, List<SchemaElement> presentElements) {
        for (XSModelGroup subGroup : subGroups) {
            List<SchemaElement> subElems = this.getAllElements(subGroup);
            for (SchemaElement present : presentElements) {
                if (!subElems.contains(present)) continue;
                subGroups.clear();
                subGroups.add(subGroup);
                return new ArrayList<SchemaElement>();
            }
        }
        for (SchemaElement present : presentElements) {
            if (!availableElements.contains(present)) continue;
            ArrayList<SchemaElement> ret = new ArrayList<SchemaElement>();
            if (present.particle != null && (present.particle.getMaxOccursUnbounded() || this.getElementCount(presentElements, present) < present.particle.getMaxOccurs())) {
                ret.add(present);
            }
            subGroups.clear();
            return ret;
        }
        return availableElements;
    }

    private List<SchemaElement> getSequenceElements(List<SchemaElement> availableElements, List<SchemaElement> presentElements) {
        ArrayList<SchemaElement> l = new ArrayList<SchemaElement>(availableElements.size());
        for (SchemaElement available : availableElements) {
            if (available.particle == null || !available.particle.getMaxOccursUnbounded() && this.getElementCount(presentElements, available) >= available.particle.getMaxOccurs()) continue;
            l.add(available);
        }
        return l;
    }

    private int getElementCount(List<SchemaElement> list, SchemaElement element) {
        int count = 0;
        for (SchemaElement el : list) {
            if (!el.equals(element)) continue;
            ++count;
        }
        return count;
    }

    private List<SchemaElement> getElements(XSModelGroup group) {
        LinkedList<SchemaElement> l = new LinkedList<SchemaElement>();
        XSObjectList list = group.getParticles();
        int i = 0;
        while (i < list.getLength()) {
            XSParticle part;
            XSTerm term;
            XSObject item = list.item(i);
            if (item instanceof XSParticle && (term = (part = (XSParticle)item).getTerm()) instanceof XSElementDeclaration) {
                l.add(new SchemaElement((XSElementDeclaration)term, part, group));
            }
            ++i;
        }
        return l;
    }

    private List<SchemaElement> getAllElements(XSModelGroup group) {
        LinkedList<SchemaElement> l = new LinkedList<SchemaElement>();
        XSObjectList list = group.getParticles();
        int i = 0;
        while (i < list.getLength()) {
            XSObject item = list.item(i);
            if (item instanceof XSParticle) {
                XSParticle part = (XSParticle)item;
                XSTerm term = part.getTerm();
                if (term instanceof XSElementDeclaration) {
                    l.add(new SchemaElement((XSElementDeclaration)term, part, group));
                } else if (term instanceof XSModelGroup) {
                    l.addAll(this.getAllElements((XSModelGroup)term));
                }
            }
            ++i;
        }
        return l;
    }

    private List<XSModelGroup> getSubGroups(XSModelGroup group) {
        LinkedList<XSModelGroup> l = new LinkedList<XSModelGroup>();
        XSObjectList list = group.getParticles();
        int i = 0;
        while (i < list.getLength()) {
            XSParticle part;
            XSTerm term;
            XSObject item = list.item(i);
            if (item instanceof XSParticle && (term = (part = (XSParticle)item).getTerm()) instanceof XSModelGroup) {
                l.add((XSModelGroup)term);
            }
            ++i;
        }
        return l;
    }

    public boolean isSequenceOfAny() {
        XSWildcard wildCard;
        XSTerm subTerm;
        XSObject subPart;
        XSObjectList subPartList;
        XSTerm term;
        XSParticle part;
        if (this.anySequenceElement != null) {
            return !this.anySequenceElement.equals(AnyElement.NO_ANY_ELEMENT);
        }
        XSTypeDefinition type = this.ctx.getTypeDefinition();
        if (type instanceof XSComplexTypeDefinition && !"http://www.w3.org/2001/XMLSchema".equals(type.getNamespace()) && (part = ((XSComplexTypeDefinition)type).getParticle()) != null && (term = part.getTerm()) instanceof XSModelGroup && (subPartList = ((XSModelGroup)term).getParticles()).getLength() == 1 && (subPart = subPartList.item(0)) instanceof XSParticle && (subTerm = ((XSParticle)subPart).getTerm()) instanceof XSWildcard && (wildCard = (XSWildcard)subTerm).getConstraintType() == 1) {
            this.anySequenceElement = new AnyElement(wildCard);
            return true;
        }
        this.anySequenceElement = AnyElement.NO_ANY_ELEMENT;
        return false;
    }

    public AnyElement getAnySequenceElement() {
        if (this.isSequenceOfAny()) {
            return this.anySequenceElement;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SchemaElement)) {
            return false;
        }
        SchemaElement se = (SchemaElement)obj;
        return this.ctx.equals(se.ctx);
    }

    public int hashCode() {
        return this.ctx.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    private String toRawString() {
        String shortNS = this.getShortNameSpace();
        return shortNS == null ? this.getName() : String.valueOf(shortNS) + ":" + this.getName();
    }

    public int compareTo(Object o) {
        if (o instanceof SchemaElement) {
            return this.getName().compareTo(((SchemaElement)o).getName());
        }
        return 0;
    }
}

