/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.io.IOException;
import java.net.URL;
import org.eclipse.stp.xef.util.InputStreamHelper;

public final class XefConstants {
    public static final String XEF_EDITOR = "org.eclipse.stp.ui.xef.editor.XefEditor";
    public static final String POLICY_HELP_VIEW = "org.eclipse.stp.ui.xef.help.XefHelpView";
    public static final String XEF_NS = "http://schemas.eclipse.org/stp/xsd/2006/05/xef";
    public static final String XEF_GUI_NS = "http://schemas.eclipse.org/stp/xsd/2006/05/xef/gui";
    static final String SECURITY_POLICY_SCHEMA;
    static final String RELIABILITY_POLICY_SCHEMA;
    static final String MAX_INVOCATION_TIME_POLICY_SCHEMA;
    static final String REPLICATED_POLICY_SCHEMA;
    static final String ROUTING_POLICY_SCHEMA;
    static final String LOGGING_POLICY_SCHEMA;

    static {
        try {
            SECURITY_POLICY_SCHEMA = XefConstants.loadSchema("/example_secure.xsd");
            RELIABILITY_POLICY_SCHEMA = XefConstants.loadSchema("/example_reliable.xsd");
            MAX_INVOCATION_TIME_POLICY_SCHEMA = XefConstants.loadSchema("/example_max_invocation_time.xsd");
            REPLICATED_POLICY_SCHEMA = XefConstants.loadSchema("/example_replication.xsd");
            ROUTING_POLICY_SCHEMA = XefConstants.loadSchema("/example_routing.xsd");
            LOGGING_POLICY_SCHEMA = XefConstants.loadSchema("/example_logging.xsd");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private XefConstants() {
    }

    private static String loadSchema(String filename) throws IOException {
        URL url = XefConstants.class.getClassLoader().getResource(filename);
        return new String(InputStreamHelper.drain(url.openStream()));
    }
}

