/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.internal.preferences;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.ui.internal.preferences.ICategoryTreeNode;
import org.eclipse.emf.validation.ui.internal.preferences.IConstraintNode;
import org.eclipse.jface.viewers.CheckStateChangedEvent;

public class ConstraintNode
implements IConstraintNode {
    private static final Map instanceMap = new HashMap();
    private final IConstraintDescriptor constraint;
    private Boolean mandatory;
    private boolean checked = false;
    private final Set categories = new HashSet();

    private ConstraintNode(IConstraintDescriptor constraint) {
        this.constraint = constraint;
        this.checked = constraint.isEnabled();
    }

    static IConstraintNode getInstance(IConstraintDescriptor constraint) {
        String id = constraint.getId();
        IConstraintNode result = null;
        if (id != null && (result = (IConstraintNode)instanceMap.get(id)) == null) {
            result = new ConstraintNode(constraint);
            instanceMap.put(id, result);
        }
        return result;
    }

    public static void flushCache() {
        instanceMap.clear();
    }

    public String getId() {
        return this.constraint.getId();
    }

    public String getName() {
        return this.constraint.getName();
    }

    public String getDescription() {
        return this.constraint.getDescription();
    }

    public Collection getCategories() {
        return this.constraint.getCategories();
    }

    public String getEvaluationMode() {
        return this.constraint.getEvaluationMode().getLocalizedName();
    }

    public String getSeverity() {
        return this.constraint.getSeverity().getLocalizedName();
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        if (checked != this.isChecked()) {
            this.checked = this.isMandatory() ? true : (this.isErrored() ? false : checked);
            this.updateCategories();
        }
    }

    public boolean isMandatory() {
        if (this.mandatory == null) {
            boolean m = false;
            Iterator iter = this.constraint.getCategories().iterator();
            while (!m && iter.hasNext()) {
                if (!((Category)iter.next()).isMandatory()) continue;
                m = true;
            }
            this.mandatory = m ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.mandatory;
    }

    public boolean isErrored() {
        return this.constraint.isError();
    }

    public void addCategory(ICategoryTreeNode category) {
        this.categories.add(category);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getChecked() != this.isChecked()) {
            if (this.isMandatory() && !event.getChecked()) {
                event.getCheckable().setChecked((Object)this, true);
            } else if (this.isErrored() && event.getChecked()) {
                event.getCheckable().setChecked((Object)this, false);
            } else {
                this.checked = event.getChecked();
            }
            this.updateCategories();
        }
    }

    public void applyToPreferences() {
        EMFModelValidationPreferences.setConstraintDisabled((String)this.constraint.getId(), (!this.isChecked() ? 1 : 0) != 0);
        this.constraint.setEnabled(this.isChecked());
    }

    public void revertFromPreferences() {
        this.setChecked(!EMFModelValidationPreferences.isConstraintDisabled((String)this.constraint.getId()));
    }

    public void restoreDefaults() {
        this.setChecked(!EMFModelValidationPreferences.isConstraintDisabledByDefault((String)this.constraint.getId()));
    }

    private void updateCategories() {
        Iterator iter = this.categories.iterator();
        while (iter.hasNext()) {
            ICategoryTreeNode next = (ICategoryTreeNode)iter.next();
            next.updateCheckState(this);
        }
    }
}

