/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.sdo.presentation;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.impl.DynamicEDataObjectImpl;
import org.eclipse.emf.ecore.sdo.presentation.SDOEditorPlugin;
import org.eclipse.emf.ecore.sdo.provider.SDOEditPlugin;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOModelWizard
extends Wizard
implements INewWizard {
    protected SDOPackage sdoPackage = SDOPackage.eINSTANCE;
    protected SDOFactory sdoFactory = this.sdoPackage.getSDOFactory();
    protected SDOModelWizardNewFileCreationPage newFileCreationPage;
    protected SDOModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(SDOEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SDOEditorPlugin.INSTANCE.getImage("full/wizban/NewSDO")));
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EClassifier eClassifier : this.sdoPackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        EClass eClass = (EClass)this.sdoPackage.getEClassifier(this.initialObjectCreationPage.getInitialObjectName());
        EObject rootObject = this.sdoFactory.create(eClass);
        return rootObject;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            EDataGraph eDataGraph = SDOModelWizard.this.initialObjectCreationPage.createRootObject();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            eDataGraph.getDataGraphResource().setURI(fileURI);
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", SDOModelWizard.this.initialObjectCreationPage.getEncoding());
                            eDataGraph.getDataGraphResource().save(options);
                        }
                        catch (Exception exception) {
                            SDOEditorPlugin.INSTANCE.log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)SDOEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            SDOEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new SDOModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(SDOEditorPlugin.INSTANCE.getString("_UI_SDOModelWizard_label"));
        this.newFileCreationPage.setDescription(SDOEditorPlugin.INSTANCE.getString("_UI_SDOModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameDefaultBase")) + "." + SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameExtension"));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameExtension");
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.initialObjectCreationPage = new SDOModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(SDOEditorPlugin.INSTANCE.getString("_UI_SDOModelWizard_label"));
        this.initialObjectCreationPage.setDescription(SDOEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SDOModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Combo initialObjectField;
        protected List<String> encodings;
        protected String modelURI;
        protected CCombo modelURIField;
        protected String modelObject;
        protected EDataGraph eDataGraph;
        protected boolean isType;
        protected String encoding;
        protected CCombo encodingField;
        protected ModifyListener validator;

        public SDOModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SDOModelWizardInitialObjectCreationPage.this.setPageComplete(SDOModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public EDataGraph createRootObject() {
            if (this.isType) {
                this.eDataGraph.createRootObject(this.eDataGraph.getType(this.getModelURI(), this.getModelObject()));
            } else {
                EClass documentRoot = (EClass)this.eDataGraph.getEClassifier(this.getModelURI(), "");
                EObject rootObject = this.eDataGraph.createEObject(documentRoot);
                this.eDataGraph.setERootObject(rootObject);
                EStructuralFeature eStructuralFeature = documentRoot.getEStructuralFeature(this.getModelObject());
                if (!(eStructuralFeature instanceof EAttribute)) {
                    rootObject.eSet(eStructuralFeature, (Object)this.eDataGraph.createEObject((EClass)eStructuralFeature.getEType()));
                }
            }
            return this.eDataGraph;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            FormLayout layout = new FormLayout();
            layout.marginTop = 10;
            layout.spacing = 10;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label modelURILabel = new Label(composite, 16384);
            modelURILabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_ModelURI"));
            data = new FormData();
            data.left = new FormAttachment(0);
            modelURILabel.setLayoutData((Object)data);
            this.modelURIField = new CCombo(composite, 2048);
            data = new FormData();
            data.top = new FormAttachment((Control)modelURILabel, 5);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.modelURIField.setLayoutData((Object)data);
            Composite buttonComposite = new Composite(composite, 0);
            FormData data2 = new FormData();
            data2.top = new FormAttachment((Control)modelURILabel, 0, 0x1000000);
            data2.right = new FormAttachment(100);
            buttonComposite.setLayoutData((Object)data2);
            RowLayout layout2 = new RowLayout();
            layout2.justify = true;
            layout2.pack = true;
            layout2.spacing = 15;
            buttonComposite.setLayout((Layout)layout2);
            Button modelURIBrowseFileSystemButton = new Button(buttonComposite, 8);
            modelURIBrowseFileSystemButton.setText(SDOEditorPlugin.INSTANCE.getString("_UI_BrowseFileSystem_label"));
            final String[] filters = new String[]{"*.xsd;*.wsdl;*.ecore;*.emof", "*.xsd;*.wsdl", "*.xsd", "*.wsdl", "*.ecore;*.emof", "*.ecore", "*.emof"};
            final List<String> suffixList = Arrays.asList("xsd", "wsdl", "ecore", "emof");
            modelURIBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(SDOModelWizardInitialObjectCreationPage.this.getShell());
                    fileDialog.setFilterExtensions(filters);
                    fileDialog.open();
                    if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
                        String filePath = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileDialog.getFileName();
                        SDOModelWizardInitialObjectCreationPage.this.modelURIField.setText((String.valueOf(SDOModelWizardInitialObjectCreationPage.this.modelURIField.getText()) + "  " + URI.createFileURI((String)filePath).toString()).trim());
                        SDOModelWizardInitialObjectCreationPage.this.loadModelURI();
                    }
                }
            });
            Button modelURIBrowseWorkspaceButton = new Button(buttonComposite, 8);
            modelURIBrowseWorkspaceButton.setText(SDOEditorPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label"));
            modelURIBrowseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ViewerFilter viewerFilter = new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            return !(element instanceof IFile) || suffixList.contains(((IFile)element).getFileExtension());
                        }
                    };
                    IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)SDOModelWizardInitialObjectCreationPage.this.getShell(), null, (String)SDOEditorPlugin.INSTANCE.getString("_UI_SelectTheModel_label"), (boolean)true, null, Collections.singletonList(viewerFilter));
                    if (files.length > 0) {
                        StringBuffer text = new StringBuffer();
                        int i = 0;
                        while (i < files.length) {
                            text.append(URI.createPlatformResourceURI((String)files[i].getFullPath().toString(), (boolean)true));
                            text.append("  ");
                            ++i;
                        }
                        SDOModelWizardInitialObjectCreationPage.this.modelURIField.setText((String.valueOf(SDOModelWizardInitialObjectCreationPage.this.modelURIField.getText()) + "  " + text.toString()).trim());
                        SDOModelWizardInitialObjectCreationPage.this.loadModelURI();
                    }
                }
            });
            ArrayList packageURIs = new ArrayList(EPackage.Registry.INSTANCE.keySet());
            Collections.sort(packageURIs, CommonPlugin.INSTANCE.getComparator());
            for (String objectName : packageURIs) {
                this.modelURIField.add(objectName);
            }
            this.modelURIField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SDOModelWizardInitialObjectCreationPage.this.loadModelURI();
                }
            });
            Label initialObjectLabel = new Label(composite, 16384);
            initialObjectLabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            FormData data3 = new FormData();
            data3.top = new FormAttachment((Control)this.modelURIField, 15);
            data3.left = new FormAttachment(0);
            initialObjectLabel.setLayoutData((Object)data3);
            this.initialObjectField = new Combo(composite, 2048);
            data3 = new FormData();
            data3.top = new FormAttachment((Control)initialObjectLabel, 5);
            data3.left = new FormAttachment(0);
            data3.right = new FormAttachment(100);
            this.initialObjectField.setLayoutData((Object)data3);
            Button loadModelButton = new Button(composite, 8);
            loadModelButton.setText(SDOEditorPlugin.INSTANCE.getString("_UI_Load_label"));
            FormData data4 = new FormData();
            data4.top = new FormAttachment((Control)initialObjectLabel, 0, 0x1000000);
            data4.right = new FormAttachment(100);
            loadModelButton.setLayoutData((Object)data4);
            loadModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SDOModelWizardInitialObjectCreationPage.this.loadModelURI();
                }
            });
            this.initialObjectField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SDOModelWizardInitialObjectCreationPage.this.setPageComplete(SDOModelWizardInitialObjectCreationPage.this.isPageComplete());
                }
            });
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(SDOEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            FormData data5 = new FormData();
            data5.top = new FormAttachment((Control)this.initialObjectField, 15);
            data5.left = new FormAttachment(0);
            encodingLabel.setLayoutData((Object)data5);
            this.encodingField = new CCombo(composite, 2048);
            data5 = new FormData();
            data5.top = new FormAttachment((Control)encodingLabel, 5);
            data5.left = new FormAttachment(0);
            data5.right = new FormAttachment(100);
            this.encodingField.setLayoutData((Object)data5);
            StringTokenizer stringTokenizer = new StringTokenizer(SDOEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
            while (stringTokenizer.hasMoreTokens()) {
                this.encodingField.add(stringTokenizer.nextToken());
            }
            this.encodingField.select(0);
            composite.setTabList(new Control[]{buttonComposite, this.modelURIField, loadModelButton, this.initialObjectField, this.encodingField});
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.initialObjectField.getItemCount() == 1) {
                    this.initialObjectField.clearSelection();
                    this.encodingField.setFocus();
                } else {
                    this.encodingField.clearSelection();
                    this.modelURIField.setFocus();
                }
            }
        }

        protected void loadModelURI() {
            this.eDataGraph = SDOFactory.eINSTANCE.createEDataGraph();
            ResourceSet resourceSet = this.eDataGraph.getResourceSet();
            Resource resource = resourceSet.getResource(URI.createURI((String)this.getModelURI()), true);
            ArrayList<String> objectNames = new ArrayList<String>();
            for (Object object : resource.getContents()) {
                if (!(object instanceof EPackage)) continue;
                EPackage ePackage = (EPackage)object;
                if (resource.getResourceSet() == resourceSet) {
                    ePackage.setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
                    resourceSet.getPackageRegistry().put((Object)resource.getURI().toString(), (Object)ePackage);
                    resourceSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
                } else if (resourceSet.getPackageRegistry().getEPackage(this.getModelURI()) != null) {
                    ePackage = resourceSet.getPackageRegistry().getEPackage(this.getModelURI());
                }
                EClass documentRoot = ExtendedMetaData.INSTANCE.getDocumentRoot(ePackage);
                if (documentRoot != null) {
                    this.isType = false;
                    for (EStructuralFeature eStructuralFeature : ExtendedMetaData.INSTANCE.getElements(documentRoot)) {
                        objectNames.add(eStructuralFeature.getName());
                    }
                } else {
                    this.isType = true;
                    for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                        if (!(eClassifier instanceof EClass)) continue;
                        objectNames.add(eClassifier.getName());
                    }
                }
                break;
            }
            this.initialObjectField.removeAll();
            Collections.sort(objectNames, CommonPlugin.INSTANCE.getComparator());
            for (String objectName : objectNames) {
                this.initialObjectField.add(objectName);
            }
            this.setPageComplete(this.isPageComplete());
        }

        public boolean isPageComplete() {
            return this.initialObjectField.getSelectionIndex() != -1;
        }

        public boolean performFinish() {
            this.modelURI = this.getModelURI();
            this.modelObject = this.getModelObject();
            this.encoding = this.getEncoding();
            return true;
        }

        public String getInitialObjectName() {
            String label = this.initialObjectField.getText();
            for (String name : SDOModelWizard.this.getInitialObjectNames()) {
                if (!this.getLabel(name).equals(label)) continue;
                return name;
            }
            return null;
        }

        public String getModelURI() {
            return this.modelURI == null ? this.modelURIField.getText() : this.modelURI;
        }

        public String getModelObject() {
            return this.modelObject == null ? this.initialObjectField.getText() : this.modelObject;
        }

        public String getEncoding() {
            return this.encoding == null ? this.encodingField.getText() : this.encoding;
        }

        protected String getLabel(String typeName) {
            try {
                return SDOEditPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
            }
            catch (MissingResourceException mre) {
                SDOEditorPlugin.INSTANCE.log(mre);
                return typeName;
            }
        }

        protected Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(SDOEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }

    public class SDOModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        protected IFile modelFile;

        public SDOModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String requiredExt = SDOEditorPlugin.INSTANCE.getString("_UI_SDOEditorFilenameExtension");
                String enteredExt = new Path(this.getFileName()).getFileExtension();
                if (enteredExt == null || !enteredExt.equals(requiredExt)) {
                    this.setErrorMessage(SDOEditorPlugin.INSTANCE.getString("_WARN_FilenameExtension", new Object[]{requiredExt}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean performFinish() {
            this.modelFile = this.getModelFile();
            return true;
        }

        public IFile getModelFile() {
            return this.modelFile == null ? ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName())) : this.modelFile;
        }
    }
}

