/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.validation.internal.EMFModelValidationDebugOptions;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.IConstraintDescriptor;

public class CategoryManager {
    static final String DEFAULT_CATEGORY_NAME = ValidationMessages.category_default_name;
    static final String DEFAULT_CATEGORY_DESCRIPTION = ValidationMessages.category_default_desc;
    private static final CategoryManager INSTANCE = new CategoryManager();
    private final Category globalCategory = Category.GLOBAL_NAMESPACE;

    static {
        INSTANCE.initDefaultCategory();
        INSTANCE.loadCategories();
    }

    private CategoryManager() {
    }

    public static CategoryManager getInstance() {
        return INSTANCE;
    }

    public SortedSet getTopLevelCategories() {
        return this.globalCategory.getChildren();
    }

    public Category getDefaultCategory() {
        return Category.DEFAULT_CATEGORY;
    }

    public Category getCategory(String path) {
        return this.globalCategory.getDescendent(path, true);
    }

    public Category getCategory(Category parent, String path) {
        if (parent == null) {
            return this.globalCategory.getDescendent(path, true);
        }
        return parent.getDescendent(path, true);
    }

    public Category findCategory(String path) {
        return this.globalCategory.getDescendent(path, false);
    }

    public Category findCategory(Category parent, String path) {
        if (parent == null) {
            return this.globalCategory.getDescendent(path, false);
        }
        return parent.getDescendent(path, false);
    }

    public void removeCategory(Category category) {
        if (category.getParent() == null) {
            throw new IllegalArgumentException();
        }
        ArrayList children = new ArrayList(category.getChildren());
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            this.removeCategory((Category)iter.next());
        }
        ArrayList constraints = new ArrayList(category.getConstraints());
        Iterator iter2 = constraints.iterator();
        while (iter2.hasNext()) {
            category.removeConstraint((IConstraintDescriptor)iter2.next());
        }
        category.getParent().removeChild(category.getId());
    }

    public void removeCategory(String path) {
        Category category = this.findCategory(path);
        if (category != null) {
            this.removeCategory(category);
        }
    }

    private void initDefaultCategory() {
        Category.DEFAULT_CATEGORY.setName(DEFAULT_CATEGORY_NAME);
        Category.DEFAULT_CATEGORY.setDescription(DEFAULT_CATEGORY_DESCRIPTION);
    }

    private void loadCategories() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getExtensionPoint(EMFModelValidationPlugin.getPluginId(), "constraintProviders").getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement next = elements[i];
            if (next.getName().equals("category")) {
                this.loadCategories(this.globalCategory, next);
            }
            ++i;
        }
    }

    private void loadCategories(Category parent, IConfigurationElement element) {
        String path = element.getAttribute("id");
        if (path != null && path.length() > 0) {
            Category category = this.getCategory(parent, path);
            String name = element.getAttribute("name");
            if (name != null) {
                category.setName(name);
            }
            category.setDescription(element.getValue());
            String mandatory = element.getAttribute("mandatory");
            if (mandatory != null) {
                category.setMandatory(Boolean.valueOf(mandatory));
            }
            IConfigurationElement[] subcategories = element.getChildren("category");
            int i = 0;
            while (i < subcategories.length) {
                this.loadCategories(category, subcategories[i]);
                ++i;
            }
        } else {
            Trace.trace(EMFModelValidationDebugOptions.XML, "No ID found for category: " + element.getAttribute("name"));
        }
    }

    public Collection getMandatoryCategories() {
        ArrayList result = new ArrayList();
        this.globalCategory.getMandatoryCategories(result);
        return result;
    }
}

