/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.example;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.stp.soas.deploy.core.FilePackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConstructor;
import org.eclipse.stp.soas.deploy.core.IPackageCreationContext;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.ServerType;
import org.eclipse.stp.soas.example.DeployDriverExamplePlugin;
import org.eclipse.stp.soas.example.IDeployConstants;

public class JARFilePackageConstructor
implements IPackageConstructor {
    public IPackageOutputDescriptor createPackage(ILogicalPackage pkg, IPackageCreationContext context, IPackageConfiguration configuration) throws CoreException {
        File outputFolder = context.getOutputFolder();
        try {
            JarPackageData jpd = this.readJarPackageDescriptor(pkg.getFile());
            IPath jarPath = new Path(outputFolder.getAbsolutePath()).append(jpd.getAbsoluteJarLocation().lastSegment());
            jpd.setJarLocation(jarPath);
            if (jarPath.toFile().exists()) {
                switch (context.promptForOverwrite(jarPath.toString())) {
                    case 1: {
                        jpd.setOverwrite(true);
                        jpd.createJarExportRunnable(null).run((IProgressMonitor)new NullProgressMonitor());
                        break;
                    }
                    case 3: {
                        throw new InterruptedException();
                    }
                }
            } else {
                jpd.createJarExportRunnable(null).run((IProgressMonitor)new NullProgressMonitor());
            }
            return new FilePackageOutputDescriptor(jpd.getAbsoluteJarLocation().toFile(), pkg.getTechnologyType(), (IServerType)new ServerType("org.eclipse.stp.soas.example.jarFileServer", (IVersion)IDeployConstants.JAR_DEFAULT_DEPLOY_VERSION), jarPath.toString(), jarPath.lastSegment());
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException() == null ? e : e.getTargetException();
            Status status = new Status(4, DeployDriverExamplePlugin.getDefault().getBundle().getSymbolicName(), -1, t.getMessage(), t);
            throw new CoreException((IStatus)status);
        }
        catch (InterruptedException e) {
            Status status = new Status(8, DeployDriverExamplePlugin.getDefault().getBundle().getSymbolicName(), -1, new String(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private JarPackageData readJarPackageDescriptor(IFile file) throws CoreException {
        JarPackageData jpd = new JarPackageData();
        IJarDescriptionReader reader = null;
        try {
            reader = jpd.createJarDescriptionReader(file.getContents());
            reader.read(jpd);
            jpd.setSaveManifest(false);
            jpd.setSaveDescription(false);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return jpd;
    }
}

