/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.example;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageValidator;
import org.eclipse.stp.soas.example.DeployDriverExamplePlugin;

public class JARPackageValidator
implements IPackageValidator {
    public IStatus[] validate(ILogicalPackage pkg, IPackageConfiguration configuration, IDeployTarget target) {
        try {
            JarPackageData jpd = this.readJarPackageDescriptor(pkg.getFile());
            if (!jpd.isValid()) {
                return new IStatus[]{new Status(4, DeployDriverExamplePlugin.getDefault().getBundle().getSymbolicName(), -1, "Package " + pkg.getFile().getFullPath() + " contains errors.", null)};
            }
            return new IStatus[0];
        }
        catch (CoreException coreException) {
            return new IStatus[]{new Status(4, DeployDriverExamplePlugin.getDefault().getBundle().getSymbolicName(), -1, "Invalid jardesc file.  Could not read " + pkg.getFile().getFullPath() + ".", null)};
        }
    }

    private JarPackageData readJarPackageDescriptor(IFile file) throws CoreException {
        JarPackageData jpd = new JarPackageData();
        IJarDescriptionReader reader = null;
        try {
            reader = jpd.createJarDescriptionReader(file.getContents());
            reader.read(jpd);
            jpd.setSaveManifest(false);
            jpd.setSaveDescription(false);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return jpd;
    }
}

