/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.swt.graphics.Cursor;

public class AbstractConnectionCreationTool
extends TargetingTool {
    protected static final int STATE_CONNECTION_STARTED = 64;
    protected static final int MAX_STATE = 64;
    private static final int FLAG_SOURCE_FEEDBACK = 64;
    protected static final int MAX_FLAG = 64;
    private EditPart connectionSource;
    private CreationFactory factory;
    private EditPartViewer viewer;
    private EditPartListener.Stub deactivationListener = new EditPartListener.Stub(){

        public void partDeactivated(EditPart editpart) {
            AbstractConnectionCreationTool.this.handleSourceDeactivated();
        }
    };

    public AbstractConnectionCreationTool() {
        this.setDefaultCursor(SharedCursors.CURSOR_PLUG);
        this.setDisabledCursor(SharedCursors.CURSOR_PLUG_NOT);
    }

    public AbstractConnectionCreationTool(CreationFactory factory) {
        this();
        this.setFactory(factory);
    }

    protected Cursor calculateCursor() {
        if (this.isInState(1) && this.getCurrentCommand() != null) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    protected Request createTargetRequest() {
        CreateConnectionRequest req = new CreateConnectionRequest();
        req.setFactory(this.getFactory());
        return req;
    }

    public void deactivate() {
        this.eraseSourceFeedback();
        this.setConnectionSource(null);
        super.deactivate();
        this.setState(0x40000000);
        this.viewer = null;
    }

    protected void eraseSourceFeedback() {
        if (!this.isShowingSourceFeedback()) {
            return;
        }
        this.setFlag(64, false);
        if (this.connectionSource != null) {
            this.connectionSource.eraseSourceFeedback(this.getSourceRequest());
        }
    }

    protected String getCommandName() {
        if (this.isInState(96)) {
            return "connection end";
        }
        return "connection start";
    }

    protected String getDebugName() {
        return "Connection Creation Tool";
    }

    protected String getDebugNameForState(int s) {
        if (s == 64 || s == 32) {
            return "Connection Started";
        }
        return super.getDebugNameForState(s);
    }

    protected CreationFactory getFactory() {
        return this.factory;
    }

    protected Request getSourceRequest() {
        return this.getTargetRequest();
    }

    protected boolean handleButtonDown(int button) {
        if (this.isInState(1) && button == 1) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.setConnectionSource(this.getTargetEditPart());
            Command command = this.getCommand();
            ((CreateConnectionRequest)this.getTargetRequest()).setSourceEditPart(this.getTargetEditPart());
            if (command != null) {
                this.setState(64);
                this.setCurrentCommand(command);
                this.viewer = this.getCurrentViewer();
            }
        }
        if (this.isInState(1) && button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.isInState(0x40000008)) {
            this.handleFinished();
        }
        return true;
    }

    protected boolean handleCommandStackChanged() {
        if (!this.isInState(1)) {
            if (this.getCurrentInput().isMouseButtonDown(1)) {
                this.setState(8);
            } else {
                this.setState(1);
            }
            this.handleInvalidInput();
            return true;
        }
        return false;
    }

    protected boolean handleCreateConnection() {
        this.eraseSourceFeedback();
        Command endCommand = this.getCommand();
        this.setCurrentCommand(endCommand);
        this.executeCurrentCommand();
        return true;
    }

    protected boolean handleDrag() {
        if (this.isInState(64)) {
            return this.handleMove();
        }
        return false;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(32)) {
            return this.handleMove();
        }
        return false;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(64)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.setState(8);
            this.handleFinished();
        }
        return super.handleFocusLost();
    }

    protected boolean handleHover() {
        if (this.isInState(64)) {
            this.updateAutoexposeHelper();
        }
        return true;
    }

    protected boolean handleInvalidInput() {
        this.eraseSourceFeedback();
        this.setConnectionSource(null);
        return super.handleInvalidInput();
    }

    protected boolean handleMove() {
        if (this.isInState(64) && this.viewer != this.getCurrentViewer()) {
            return false;
        }
        if (this.isInState(97)) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected void handleSourceDeactivated() {
        this.setState(8);
        this.handleInvalidInput();
        this.handleFinished();
    }

    protected boolean isShowingSourceFeedback() {
        return this.getFlag(64);
    }

    protected void setConnectionSource(EditPart source) {
        if (this.connectionSource != null) {
            this.connectionSource.removeEditPartListener(this.deactivationListener);
        }
        this.connectionSource = source;
        if (this.connectionSource != null) {
            this.connectionSource.addEditPartListener(this.deactivationListener);
        }
    }

    public void setFactory(CreationFactory factory) {
        this.factory = factory;
    }

    protected void showSourceFeedback() {
        if (this.connectionSource != null) {
            this.connectionSource.showSourceFeedback(this.getSourceRequest());
        }
        this.setFlag(64, true);
    }

    protected void updateTargetRequest() {
        CreateConnectionRequest request = (CreateConnectionRequest)this.getTargetRequest();
        request.setType(this.getCommandName());
        request.setLocation(this.getLocation());
    }
}

