/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.palette.ChangeIconSizeAction;
import org.eclipse.gef.ui.palette.CustomizeAction;
import org.eclipse.gef.ui.palette.LayoutAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PinDrawerAction;
import org.eclipse.gef.ui.palette.SettingsAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;

public class PaletteContextMenuProvider
extends ContextMenuProvider {
    public PaletteContextMenuProvider(PaletteViewer palette) {
        super(palette);
    }

    protected PaletteViewer getPaletteViewer() {
        return (PaletteViewer)this.getViewer();
    }

    public void buildContextMenu(IMenuManager menu) {
        GEFActionConstants.addStandardActionGroups(menu);
        Object selectedPart = this.getPaletteViewer().getSelectedEditParts().get(0);
        if (selectedPart instanceof DrawerEditPart && ((DrawerEditPart)selectedPart).canBePinned()) {
            menu.appendToGroup("additions", (IAction)new PinDrawerAction((DrawerEditPart)selectedPart));
        }
        menu.appendToGroup("org.eclipse.gef.group.view", (IAction)new LayoutAction(this.getPaletteViewer().getPaletteViewerPreferences()));
        menu.appendToGroup("org.eclipse.gef.group.view", (IAction)new ChangeIconSizeAction(this.getPaletteViewer().getPaletteViewerPreferences()));
        if (this.getPaletteViewer().getCustomizer() != null) {
            menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new CustomizeAction(this.getPaletteViewer()));
        }
        menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new SettingsAction(this.getPaletteViewer()));
    }
}

