/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.OperationSignature;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.w3c.dom.Document;

public class BP1116
extends AssertionProcessVisitor {
    private final BaseMessageValidator validator;
    private String action = null;
    private String headers = null;

    public BP1116(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(SOAPOperation soapOper, Object parent, WSDLTraversalContext ctx) {
        String soapAction = soapOper.getSoapActionURI();
        if (soapAction == null) {
            if (!"".equals(this.action)) {
                this.result = "failed";
                this.failureDetailMessage = "\nHTTP headers:\n" + this.headers + "\nsoapAction:\n" + soapAction;
            }
        } else if (!soapAction.equals(this.action)) {
            this.result = "failed";
            this.failureDetailMessage = "\nHTTP headers:\n" + this.headers + "\nsoapAction:\n" + soapAction;
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            OperationSignature.OperationMatch match;
            Document doc = entryContext.getMessageEntryDocument();
            this.headers = entryContext.getRequest().getHTTPHeaders();
            if (this.headers != null) {
                this.action = (String)HTTPUtils.getHttpHeaderTokens(this.headers, ":").get("SOAPAction".toUpperCase());
            }
            if (this.action == null) {
                throw new AssertionNotApplicableException();
            }
            if (this.action.length() > 1 && this.action.charAt(0) == '\"' && this.action.charAt(this.action.length() - 1) == '\"') {
                this.action = this.action.substring(1, this.action.length() - 1);
            }
            if ((match = OperationSignature.matchOperation(doc, null, this.validator.analyzerContext.getCandidateInfo().getBindings()[0], new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator), false)) != null) {
                WSDLTraversal traversal = new WSDLTraversal();
                traversal.setVisitor(this);
                traversal.visitSOAPOperation(true);
                traversal.traverse(match.getOperation());
            } else {
                this.result = "notApplicable";
            }
        }
        catch (Exception exception) {
            this.result = "notApplicable";
        }
        if (this.result == "failed" && this.failureDetailMessage != null) {
            this.failureDetail = this.validator.createFailureDetail(this.failureDetailMessage, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

