/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.jsf.common.internal.ITestTracker;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleListener
implements IResourceChangeListener {
    private static final boolean ENABLE_TEST_TRACKING = false;
    private static long _seqId;
    private final List<IResource> _resources = new ArrayList<IResource>();
    private final List<IResourceLifecycleListener> _listeners = new ArrayList<IResourceLifecycleListener>(1);
    private boolean _isDisposed = false;
    private ITestTracker _testTracker;

    public LifecycleListener() {
    }

    public LifecycleListener(IResource res) {
        this();
        this._resources.add(res);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public LifecycleListener(List<IResource> resources) {
        this();
        this._resources.addAll(resources);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public final void setTestTracker(ITestTracker testTracker) {
        this._testTracker = testTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(IResource res) {
        List<IResource> list = this._resources;
        synchronized (list) {
            int preSize = this._resources.size();
            if (!this._resources.contains(res)) {
                this._resources.add(res);
            }
            if (preSize == 0 && this._resources.size() > 0) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(IResource res) {
        List<IResource> list = this._resources;
        synchronized (list) {
            this._resources.remove(res);
            if (this._resources.size() == 0) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }

    public void dispose() {
        if (!this._isDisposed) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this._isDisposed = true;
        }
    }

    public boolean isDisposed() {
        return this._isDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IResourceLifecycleListener listener) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        List<IResourceLifecycleListener> list = this._listeners;
        synchronized (list) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IResourceLifecycleListener listener) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        List<IResourceLifecycleListener> list = this._listeners;
        synchronized (list) {
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        ++_seqId;
        assert (!this.isDisposed());
        switch (event.getType()) {
            case 2: {
                IProject proj = (IProject)event.getResource();
                List<IResource> list = this._resources;
                synchronized (list) {
                    List<IResource> resources = this.copyResourceList();
                    for (IResource res : resources) {
                        if (proj != res && proj != res.getProject()) continue;
                        this.fireLifecycleEvent(new ResourceLifecycleEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED));
                    }
                    break;
                }
            }
            case 4: {
                IProject proj = (IProject)event.getResource();
                List<IResource> list = this._resources;
                synchronized (list) {
                    List<IResource> resources = this.copyResourceList();
                    for (IResource res : resources) {
                        if (proj == res) {
                            this.fireLifecycleEvent(new ResourceLifecycleEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED));
                            continue;
                        }
                        if (proj != res.getProject()) continue;
                        this.fireLifecycleEvent(new ResourceLifecycleEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_DELETED));
                    }
                    break;
                }
            }
            case 1: {
                List<IResource> list = this._resources;
                synchronized (list) {
                    List<IResource> resources = this.copyResourceList();
                    for (IResource res : resources) {
                        if (res.getType() == 4) continue;
                        IResourceDelta delta = event.getDelta();
                        if ((delta = delta.findMember(res.getFullPath())) == null) continue;
                        this.visit(delta);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IResource> copyResourceList() {
        List<IResource> list = this._resources;
        synchronized (list) {
            ArrayList<IResource> resList = new ArrayList<IResource>(this._resources.size());
            resList.addAll(this._resources);
            return resList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLifecycleEvent(ResourceLifecycleEvent event) {
        ArrayList<IResourceLifecycleListener> copyListeners = new ArrayList<IResourceLifecycleListener>(this._listeners.size());
        List<IResourceLifecycleListener> list = this._listeners;
        synchronized (list) {
            copyListeners.addAll(this._listeners);
        }
        boolean disposeAfter = false;
        for (IResourceLifecycleListener listener : copyListeners) {
            IResourceLifecycleListener.EventResult result = listener.acceptEvent(event);
            disposeAfter |= result.getDisposeAfterEvent();
        }
        if (disposeAfter) {
            this.dispose();
        }
    }

    private void visit(IResourceDelta delta) {
        assert (!this.isDisposed());
        IResource res = delta.getResource();
        switch (delta.getKind()) {
            case 4: {
                if ((delta.getFlags() & 0x100) == 0) break;
                this.fireLifecycleEvent(new ResourceLifecycleEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_CHANGED, ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS));
                break;
            }
            case 2: {
                this.fireLifecycleEvent(new ResourceLifecycleEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED));
            }
        }
    }
}

