/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipes.stp.soas.deploy.runtime.cxf.core.internal;

import java.util.List;

import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jst.server.core.IJavaRuntime;

/**
 * cxf runtime interface, which extends from jst runtime
 * 
 * @author jma
 *
 */
public interface ICxfRuntime extends IJavaRuntime {
	
	/**
	 * Returns <code>true</code> if this server is using the default JRE, and
	 * <code>false</code> otherwise.
	 * 
	 * @return <code>true</code> if this server is using the default JRE, and
	 *    <code>false</code> otherwise
	 */
	public boolean isUsingDefaultJRE();

	/**
	 * Returns the runtime classpath that is used by this runtime.
	 * 
	 * @return the runtime classpath
	 */
	public List<IRuntimeClasspathEntry> getRuntimeClasspath();
}
