<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0" xmlns:xalan="http://xml.apache.org/xslt"
	xmlns="http://www.w3.org/2001/XMLSchema"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:ecore="http://www.eclipse.org/emf/2002/Ecore"
	xmlns:member="http://www.ibm.com" xmlns:contact="http://www.ibm.com"
	exclude-result-prefixes="contact">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"
		xalan:indent-amount="2" />
	<xsl:strip-space elements="*" />


	<xsl:template match="/">
		<xsl:apply-templates select="xs:schema" />
	</xsl:template>

	<xsl:template match="xs:schema">
		<schema xmlns="http://www.w3.org/2001/XMLSchema"
			targetNamespace="http://www.osoa.org/xmlns/sca/0.9"
			xmlns:sca="http://www.osoa.org/xmlns/sca/0.9"
			xmlns:ecore="http://www.eclipse.org/emf/2002/Ecore"
			ecore:documentRoot="SCACoreRoot" ecore:nsPrefix="sca"
			ecore:package="com.ibm.ccl.soa.core.sca.sca">

			<!--  Remove the 'Operations' canonical model
				<xsl:element name="include">
				<xsl:attribute name="schemaLocation"> 
				<xsl:value-of select="'sca-operations.xsd'" /> 
				</xsl:attribute>
				</xsl:element>
			-->
			<xsl:apply-templates
				select="xs:element[@name='componentType']" mode="componentType" />
			<xsl:apply-templates
				select="xs:complexType[@name='ComponentType']" mode="ComponentType" />
			<xsl:apply-templates
				select="xs:complexType[@name='Service']" mode="Service" />
			<xsl:apply-templates select="xs:element[@name='interface']"
				mode="interface" />
			<xsl:apply-templates
				select="xs:complexType[@name='Interface']" mode="Interface" />
			<xsl:apply-templates
				select="xs:complexType[@name='Reference']" mode="Reference" />
			<xsl:apply-templates
				select="xs:complexType[@name='Property']" mode="Property" />
			<xsl:apply-templates
				select="xs:element[@name='moduleFragment']" mode="moduleFragment" />
			<xsl:apply-templates
				select="xs:complexType[@name='ModuleFragment']"
				mode="ModuleFragment" />
			<xsl:apply-templates select="xs:element[@name='module']"
				mode="module" />
			<xsl:apply-templates select="xs:complexType[@name='Module']"
				mode="Module" />
			<xsl:apply-templates
				select="xs:complexType[@name='EntryPoint']" mode="EntryPoint" />
			<xsl:apply-templates select="xs:element[@name='binding']"
				mode="binding" />
			<xsl:apply-templates
				select="xs:complexType[@name='Binding']" mode="Binding" />
			<xsl:apply-templates
				select="xs:complexType[@name='Component']" mode="Component" />
			<xsl:apply-templates
				select="xs:element[@name='implementation']" mode="implementation" />
			<xsl:apply-templates
				select="xs:complexType[@name='Implementation']"
				mode="Implementation" />
			<xsl:apply-templates
				select="xs:complexType[@name='PropertyValues']"
				mode="PropertyValues" />
			<xsl:apply-templates
				select="xs:complexType[@name='ReferenceValues']"
				mode="ReferenceValues" />
			<xsl:apply-templates
				select="xs:complexType[@name='ExternalService']"
				mode="ExternalService" />
			<xsl:apply-templates
				select="xs:complexType[@name='ModuleWire']" mode="ModuleWire" />
			<xsl:apply-templates select="xs:element[@name='source']"
				mode="source" />
			<xsl:apply-templates select="xs:element[@name='target']"
				mode="target" />
			<xsl:apply-templates select="xs:element[@name='source.uri']"
				mode="source.uri" />
			<xsl:apply-templates select="xs:element[@name='target.uri']"
				mode="target.uri" />
			<xsl:apply-templates select="xs:element[@name='subsystem']"
				mode="subsystem" />
			<xsl:apply-templates
				select="xs:complexType[@name='Subsystem']" mode="Subsystem" />
			<xsl:apply-templates
				select="xs:complexType[@name='ModuleComponent']"
				mode="ModuleComponent" />
			<xsl:apply-templates
				select="xs:complexType[@name='SystemWire']" mode="SystemWire" />
			<xsl:apply-templates select="xs:element[@name='source.epr']"
				mode="source.epr" />
			<xsl:apply-templates select="xs:element[@name='target.epr']"
				mode="target.epr" />
			<xsl:apply-templates
				select="xs:simpleType[@name='Multiplicity']" mode="Multiplicity" />
			<xsl:apply-templates
				select="xs:simpleType[@name='OverrideOptions']"
				mode="OverrideOptions" />
			<xsl:call-template name="CompositionDCPAdditions" />
			<xsl:call-template name="AbstractImplementation" />
			<xsl:call-template name="UnknownImplementation" />
		</schema>
	</xsl:template>

	<!-- Composition DCP additions -->
	<!-- We have removed wires since all composites must be fully encapsulated. -->
	<!-- TODO:  We still need exposed properties. -->
	<xsl:template name="CompositionDCPAdditions">
		<element name="composite" type="sca:Composite" /> 
		<complexType name="Composite"> 
			<sequence>
				<element minOccurs="0" maxOccurs="unbounded"
					name="entryPoint" type="sca:EntryPoint" ecore:name="entryPoints" /> 
				<element minOccurs="0" maxOccurs="unbounded"
					ref="sca:abstractComponent" ecore:name="components" ecore:featureMap="componentsGroup" >
					<xsl:call-template name="suppressVisibility" />  
				</element>
				<element minOccurs="0" maxOccurs="unbounded"
					name="externalService" type="sca:ExternalService"
					ecore:name="externalServices" />
			</sequence> 
			<attribute name="name" type="NCName" use="required" />	  
		</complexType>
		 
		<element name="abstractComponent" type="sca:Component" />
		<complexType name="Component" abstract="true">
			<sequence>
				<element minOccurs="0" maxOccurs="1" name="properties"
					type="sca:PropertyValuesSet" ecore:name="propertyValuesSet" />
				<element minOccurs="0" maxOccurs="1" name="references"
					type="sca:ReferenceValuesSet" ecore:name="referenceValuesSet"
					ecore:opposite="component">
					<xsl:call-template name="suppressVisibility" />
				</element>
			</sequence>
			<attribute name="name" type="NCName" use="required" />
		</complexType>
		
		<complexType name="ModuleService">
			<complexContent>
				<extension base="sca:Service">
					<sequence>
						<element minOccurs="1" maxOccurs="1"
							name="entryPoint" type="anyURI" ecore:reference="sca:EntryPoint"/> 
					</sequence> 
				</extension>
			</complexContent>
		</complexType> 
		
		<complexType name="ModuleReference">
			<complexContent>
				<extension base="sca:Reference">
					<sequence>
						<element minOccurs="1" maxOccurs="1"
							name="externalService" type="anyURI" ecore:reference="sca:ExternalService" /> 
					</sequence> 
				</extension>
			</complexContent>
		</complexType>
		
		<element substitutionGroup="sca:abstractComponent" type="sca:ModuleComponent" name="moduleComponent"/>
		<element substitutionGroup="sca:abstractComponent" type="sca:ImplementationComponent" name="component"/>		
  
	</xsl:template>

	<!-- Add component type implementation to support top-down generation. -->
	<xsl:template name="AbstractImplementation">
		<element name="implementation.abstract"
			type="sca:AbstractImplementation"
			substitutionGroup="sca:implementation" />
		<complexType name="AbstractImplementation">
			<complexContent>
				<extension base="sca:Implementation">
					<sequence>
						<element minOccurs="1" maxOccurs="1"
							ref="sca:componentType" />
					</sequence>
					<attribute name="type" type="NCName" />
				</extension>
			</complexContent>
		</complexType>
	</xsl:template>
	<!-- Add component type implementation to support initializing introspectors outside of a Component generation. -->
	<xsl:template name="UnknownImplementation">
		<element name="implementation.unknown"
			type="sca:UnknownImplementation"
			substitutionGroup="sca:implementation" />
		<complexType name="UnknownImplementation">
			<complexContent>
				<extension base="sca:Implementation">
					<sequence>
						<element minOccurs="1" maxOccurs="1" name="uri"
							type="anyURI" />
					</sequence>
				</extension>
			</complexContent>
		</complexType>
	</xsl:template>

	<xsl:template match="xs:element" mode="componentType">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:complexType" mode="ComponentType">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()"
				mode="ComponentType" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="@*" mode="ComponentType">
		<xsl:attribute name="{name(.)}">
			<xsl:value-of select="." />
		</xsl:attribute>
		<xsl:variable name="v" select="string(.)" />
		<xsl:choose>
			<xsl:when test="$v='reference'">
				<xsl:attribute name="ecore:name">
					<xsl:value-of select="'references'" />
				</xsl:attribute>
			</xsl:when>
			<xsl:when test="$v='property'">
				<xsl:attribute name="ecore:name">
					<xsl:value-of select="'properties'" />

				</xsl:attribute>
			</xsl:when>
			<xsl:when test="$v='service'">
				<xsl:attribute name="ecore:name">
					<xsl:value-of select="'services'" />
				</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*|comment()|processing-instruction()|text()"
		mode="ComponentType">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()"
				mode="ComponentType" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:complexType" mode="Service">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()"
				mode="Service" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="@*" mode="Service">
		<xsl:attribute name="{name(.)}">
			<xsl:value-of select="." />
		</xsl:attribute>
		<xsl:if test="string(.)='sca:interface'">
			<xsl:attribute name="ecore:featureMap">
				<xsl:value-of select="'interfaceGroup'" />

			</xsl:attribute>
		</xsl:if>
	</xsl:template>

	<xsl:template match="*|comment()|processing-instruction()|text()"
		mode="Service">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()"
				mode="Service" />
			<xsl:variable name="v" select="string(@ref)" />
			<xsl:if test="$v='sca:interface'">
				<xsl:call-template name="suppressVisibility" />
			</xsl:if>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:element" mode="interface">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:complexType" mode="Interface">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
			<!--  Remove the 'Operations' structural feature 
				<xsl:element name="sequence">
				<xsl:element name="element">
				<xsl:attribute name="maxOccurs">
				<xsl:value-of select="'unbounded'" />
				
				</xsl:attribute>
				<xsl:attribute name="minOccurs">0</xsl:attribute>
				<xsl:attribute name="ecore:name"> 
				<xsl:value-of select="'operations'" />
				</xsl:attribute>
				<xsl:attribute name="ref">
				<xsl:value-of select="'sca:operation'" />  
				</xsl:attribute>
				</xsl:element>
				</xsl:element>
			-->
		</xsl:copy>
	</xsl:template>


	<xsl:template match="xs:complexType" mode="Reference">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()"
				mode="Reference" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="@*" mode="Reference">
		<xsl:attribute name="{name(.)}">
			<xsl:value-of select="." />
		</xsl:attribute>
		<xsl:if test="string(.)='sca:interface'">
			<xsl:attribute name="ecore:featureMap">
				<xsl:value-of select="'interfaceGroup'" />
			</xsl:attribute>
		</xsl:if>
	</xsl:template>

	<xsl:template match="*|comment()|processing-instruction()|text()"
		mode="Reference">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()"
				mode="Reference" />
			<xsl:variable name="v" select="string(@ref)" />
			<xsl:if test="$v='sca:interface'">
				<xsl:call-template name="suppressVisibility" />
			</xsl:if>
		</xsl:copy>
	</xsl:template>


	<xsl:template match="xs:complexType" mode="Property">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:element" mode="moduleFragment">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:complexType" mode="ModuleFragment">
		<complexType name="ModuleFragment">
			<complexContent>
				<extension base="sca:Composite">
					<xs:sequence>
						<xs:element minOccurs="0" maxOccurs="unbounded"
							name="wire" ecore:name="wires" type="sca:ModuleWire" />							
			            <any namespace="##other" processContents="lax" minOccurs="0" maxOccurs="unbounded"/>	
					</xs:sequence>					
			        <anyAttribute namespace="##any" processContents="lax"/>
				</extension>
			</complexContent>
		</complexType>
	</xsl:template>

	<xsl:template match="xs:element" mode="module">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:complexType" mode="Module">
		<xsl:copy>
			<xsl:apply-templates
				select="xs:*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:complexType" mode="EntryPoint">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()"
				mode="EntryPoint" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="@*" mode="EntryPoint">
		<xsl:attribute name="{name(.)}">
			<xsl:value-of select="." />
		</xsl:attribute>
		<xsl:choose>
			<xsl:when test="string(.)='reference'">
				<xsl:attribute name="ecore:name">
					<xsl:value-of select="'referenceTargets'" />
				</xsl:attribute>
				<xsl:attribute name="ecore:instanceClass">
					<xsl:value-of select="'SCAObject'" />
				</xsl:attribute>
			</xsl:when>
			<xsl:when test="string(.)='sca:binding'">
				<xsl:attribute name="ecore:name">
					<xsl:value-of select="'bindings'" />
				</xsl:attribute>
				<xsl:attribute name="ecore:featureMap">
					<xsl:value-of select="'bindingGroup'" />
				</xsl:attribute>
				<xsl:call-template name="suppressVisibility" />
			</xsl:when>
			<xsl:when test="string(.)='sca:interface'">
				<xsl:attribute name="ecore:featureMap">
					<xsl:value-of select="'interfaceGroup'" />
				</xsl:attribute>
				<xsl:call-template name="suppressVisibility" />
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*|comment()|processing-instruction()|text()"
		mode="EntryPoint">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()"
				mode="EntryPoint" />
		</xsl:copy>

	</xsl:template>

	<xsl:template match="xs:complexType" mode="ExternalService">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()"
				mode="ExternalService" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="@*" mode="ExternalService">
		<xsl:attribute name="{name(.)}">
			<xsl:value-of select="." />
		</xsl:attribute>
		<xsl:choose>
			<xsl:when test="string(.)='sca:binding'">
				<xsl:attribute name="ecore:name">
					<xsl:value-of select="'bindings'" />
				</xsl:attribute>
				<xsl:attribute name="ecore:featureMap">
					<xsl:value-of select="'bindingGroup'" />
				</xsl:attribute>
				<xsl:call-template name="suppressVisibility" />
			</xsl:when>
			<xsl:when test="string(.)='sca:interface'">
				<xsl:attribute name="ecore:featureMap">
					<xsl:value-of select="'interfaceGroup'" />
				</xsl:attribute>
				<xsl:call-template name="suppressVisibility" />
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*|comment()|processing-instruction()|text()"
		mode="ExternalService">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()"
				mode="EntryPoint" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:element" mode="binding">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:complexType" mode="Binding">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<!-- ComponentType DCP - URI pointer to the implementation/componentType. -->
	<xsl:template match="xs:complexType" mode="Component">
		<complexType name="ImplementationComponent" >
			<complexContent>
				<extension base="sca:Component">
					<sequence>
						<element minOccurs="1" maxOccurs="1"
							ref="sca:implementation">
							<xsl:call-template
								name="suppressVisibility" />
						</element>
						<any namespace="##other" processContents="lax"
							minOccurs="0" maxOccurs="unbounded" />
					</sequence>
					<anyAttribute namespace="##any"
						processContents="lax" />
				</extension>
			</complexContent>
		</complexType>
	</xsl:template>

	<xsl:template match="xs:element" mode="implementation">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<!-- Set abstract to true. -->
	<xsl:template match="xs:complexType" mode="Implementation">
		<complexType name="Implementation" abstract="true" />
	</xsl:template>

	<!-- "v" namespace DCP -->
	<xsl:template match="xs:complexType" mode="PropertyValues">
		<complexType name="PropertyValuesSet">
			<sequence>
				<element name="property" minOccurs="0"
					maxOccurs="unbounded" type="sca:PropertyValue"
					ecore:name="propertyValues" />
			</sequence>
			<anyAttribute namespace="##any" processContents="lax" />
		</complexType>
		<complexType name="PropertyValue">
			<sequence>
				<element minOccurs="1" maxOccurs="1" name="value"
					type="anySimpleType" />
			</sequence>
			<attribute name="name" type="NCName" use="required" />
		</complexType>
	</xsl:template>

	<!-- "v" namespace DCP -->
	<xsl:template match="xs:complexType" mode="ReferenceValues">
		<complexType name="ReferenceValuesSet">
			<sequence>
				<element name="reference" minOccurs="0"
					maxOccurs="unbounded" type="sca:ReferenceValue"
					ecore:name="referenceValues" ecore:opposite="referenceValueSet" />
			</sequence>
			<anyAttribute namespace="##any" processContents="lax" />
		</complexType>
		<complexType name="ReferenceValue">
			<sequence>
				<element minOccurs="1" maxOccurs="1" name="target"
					type="anyURI" ecore:name="targetURI" />
			</sequence>
			<attribute name="name" type="NCName" use="required" />
			<anyAttribute namespace="##any" processContents="lax" />
		</complexType>
	</xsl:template>

	<xsl:template match="xs:complexType" mode="ModuleWire">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:element" mode="source">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:element" mode="target">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:element" mode="source.uri">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:element" mode="target.uri">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:element" mode="subsystem">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:complexType" mode="Subsystem">
		<xsl:variable name="v" select="name(.)" />
		<xsl:choose>
			<xsl:when test="$v='complexType'">
				<xsl:element name="complexType">
					<xsl:attribute name="name">
						<xsl:value-of select="'Subsystem'" />
					</xsl:attribute>
					<complexContent>
						<extension base="sca:Composite">	
							<sequence>						  
								<element minOccurs="0" maxOccurs="unbounded" name="wire" type="sca:SystemWire" ecore:name="wires"/>
								<any namespace="##other" processContents="lax" minOccurs="0" maxOccurs="unbounded"/>   
							</sequence>
							<attribute name="uri" type="anyURI" use="optional"/>        
							<anyAttribute namespace="##any" processContents="lax"/> 
						</extension>
					</complexContent>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates
						select="*|@*|comment()|processing-instruction()|text()"
						mode="Subsystem" />
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

			<!-- 
	<xsl:template match="@*" mode="Subsystem">
		<xsl:attribute name="{name(.)}">
			<xsl:value-of select="." />
		</xsl:attribute>
		<xsl:variable name="v" select="string(.)" />
		<xsl:choose>
			<xsl:when test="$v='moduleComponent'">
				<xsl:attribute name="ecore:name">
					<xsl:value-of select="'moduleComponents'" />
				</xsl:attribute>
			</xsl:when>
			<xsl:when test="$v='wire'">
				<xsl:attribute name="ecore:name">
					<xsl:value-of select="'wires'" />
				</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

			 -->
	<xsl:template match="*|comment()|processing-instruction()|text()"
		mode="Subsystem">
		<xsl:variable name="elementName">
			<xsl:value-of select="name(.)" />
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$elementName='element'">
				<xsl:variable name="v">
					<xsl:value-of select="@name" />
				</xsl:variable>
				<xsl:choose>
					<!-- Suppress Entry Point and External Service as they are inherited from sca:CompositeFragment -->
					<xsl:when test="$v='entryPoint'" />
					<xsl:when test="$v='externalService'" />
					<xsl:otherwise>
						<xsl:copy>
							<xsl:apply-templates
								select="*|@*|comment()|processing-instruction()|text()"
								mode="Subsystem" />
						</xsl:copy>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$elementName='attribute'">
				<xsl:variable name="v">
					<xsl:value-of select="@name" />
				</xsl:variable>
				<xsl:choose>
					<!-- Suppress the 'name' attribute as it is inherited from sca:CompositeFragment -->
					<xsl:when test="$v='name'" />
					<xsl:otherwise>
						<xsl:copy>
							<xsl:apply-templates
								select="*|@*|comment()|processing-instruction()|text()"
								mode="Subsystem" />
						</xsl:copy>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates
						select="*|@*|comment()|processing-instruction()|text()"
						mode="Subsystem" />
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
  
	<xsl:template match="xs:complexType" mode="ModuleComponent">
		<xsl:variable name="v" select="name(.)" />
		<xsl:choose>
			<xsl:when test="$v='complexType'">
				<xsl:element name="complexType">
					<xsl:attribute name="name">
						<xsl:value-of select="'ModuleComponent'" />
					</xsl:attribute>
					<complexContent>
						<extension base="sca:Component">
							<xsl:apply-templates
								select="*|comment()|processing-instruction()|text()"
								mode="ModuleComponent" />
						</extension>
					</complexContent>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates
						select="*|@*|comment()|processing-instruction()|text()"
						mode="ModuleComponent" />
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template> 

	<xsl:template match="*|comment()|processing-instruction()|text()"
		mode="ModuleComponent">
		<xsl:variable name="elementName">
			<xsl:value-of select="name(.)" />
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$elementName='element'">
				<xsl:variable name="v">
					<xsl:value-of select="@name" />
				</xsl:variable>
				<xsl:choose>
					<!-- Suppress Property Values and Reference Values as they are inherited from sca:Configurable -->
					<xsl:when test="$v='properties'" />
					<xsl:when test="$v='references'" />
					<xsl:otherwise>
						<xsl:copy>
							<xsl:apply-templates
								select="*|@*|comment()|processing-instruction()|text()"
								mode="ModuleComponent" />
						</xsl:copy>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$elementName='attribute'">
				<xsl:variable name="v">
					<xsl:value-of select="@name" />
				</xsl:variable>
				<xsl:choose>
					<!-- Suppress name attribute as it is inherited from sca:Configurable -->
					<xsl:when test="$v='name'" />
					<xsl:otherwise>
						<xsl:copy>
							<xsl:apply-templates
								select="*|@*|comment()|processing-instruction()|text()"
								mode="ModuleComponent" />
						</xsl:copy>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates
						select="*|@*|comment()|processing-instruction()|text()"
						mode="ModuleComponent" />
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="@*" mode="ModuleComponent">
		<xsl:attribute name="{name(.)}">
			<xsl:value-of select="." />
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="xs:complexType" mode="SystemWire">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:element" mode="source.epr">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:element" mode="target.epr">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:simpleType" mode="Multiplicity">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="xs:simpleType" mode="OverrideOptions">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>


	<xsl:template name="suppressVisibility">
		<annotation>
			<appinfo source="http://www.eclipse.org/emf/2002/GenModel"
				ecore:key="suppressedGetVisibility">
				<xsl:value-of select="'true'" />
			</appinfo>
			<appinfo source="http://www.eclipse.org/emf/2002/GenModel"
				ecore:key="suppressedSetVisibility">
				<xsl:value-of select="'true'" />
			</appinfo>
		</annotation>
	</xsl:template>

	<xsl:template match="@*">
		<xsl:attribute name="{name(.)}">
			<xsl:value-of select="." />
		</xsl:attribute>
	</xsl:template>


	<!-- Use this template if we want to change the namespace prefix to something else.
		<xsl:template match="@*">
		<xsl:attribute name="{name(.)}">
		<xsl:choose>
		<xsl:when  test="starts-with(., 'sca:')">
		<xsl:value-of select="concat('uspm:', substring-after(.,':'))"/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="."/>
		</xsl:otherwise>
		</xsl:choose>
		</xsl:attribute>
		</xsl:template>
		
	-->

	<!-- Identity transformation template -->

	<xsl:template match="*|comment()|processing-instruction()|text()">
		<xsl:copy>
			<xsl:apply-templates
				select="*|@*|comment()|processing-instruction()|text()" />
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
