/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.internal.infrastructure.emf;

import org.eclipse.core.resources.IProject;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModel;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.EMFWorkbenchContext;

public class EditModelFactory implements IEditModelFactory {

   private static EditModelFactory eInstance;

   public static IEditModelFactory init() {
      synchronized (EditModelFactory.class) {
         if (eInstance == null) {
            eInstance = new EditModelFactory();
         }
      }
      return eInstance;
   }

   /*
    * (non-Javadoc)
    * 
    * @see com.ibm.soa.infrastructure.emf.IEditModelFactory1#getEditModel(org.eclipse.core.resources.IProject,
    *      java.lang.String)
    */
   public IEditModel getEditModel(IProject aProject, String editModelID) {
      EMFWorkbenchContext context = EMFWorkbenchContext.getInstance(aProject);
      return context.getEditModel(editModelID);
   }

   /*
    * (non-Javadoc)
    * 
    * @see com.ibm.soa.infrastructure.emf.IEditModelFactory1#createScribbler(org.eclipse.core.resources.IProject,
    *      java.lang.String, com.ibm.soa.infrastructure.emf.IScribblerDomain[],
    *      boolean)
    */
   public IEditModelScribbler createScribbler(IProject aProject,
         String editModelID, IScribblerDomain[] domains, boolean toMakeReadonly)
         throws EditModelException {
      IEditModel editModel = getEditModel(aProject, editModelID);
      return editModel.createScribbler(domains, toMakeReadonly);
   }

   /*
    * (non-Javadoc)
    * 
    * @see com.ibm.soa.infrastructure.emf.IEditModelFactory1#createScribblerForRead(org.eclipse.core.resources.IProject,
    *      java.lang.String, com.ibm.soa.infrastructure.emf.IScribblerDomain)
    */
   public IEditModelScribbler createScribblerForRead(IProject aProject,
         IScribblerDomain domain) throws EditModelException {
      IEditModel editModel = getEditModel(aProject, domain.getEditModelLabel());
      return editModel.createScribbler(new IScribblerDomain[] { domain }, true);
   }

   /*
    * (non-Javadoc)
    * 
    * @see com.ibm.soa.infrastructure.emf.IEditModelFactory1#createScribblerForWrite(org.eclipse.core.resources.IProject,
    *      java.lang.String, com.ibm.soa.infrastructure.emf.IScribblerDomain)
    */
   public IEditModelScribbler createScribblerForWrite(IProject aProject,
         IScribblerDomain domain) throws EditModelException {
      IEditModel editModel = getEditModel(aProject, domain.getEditModelLabel());
      return editModel
            .createScribbler(new IScribblerDomain[] { domain }, false);
   }

   /*
    * (non-Javadoc)
    * 
    * @see com.ibm.soa.infrastructure.emf.IEditModelFactory1#createScribblerForRead(org.eclipse.core.resources.IProject,
    *      java.lang.String, com.ibm.soa.infrastructure.emf.IScribblerDomain[])
    */
   public IEditModelScribbler createScribblerForRead(IProject aProject,
         String editModelID, IScribblerDomain[] domains)
         throws EditModelException {
      IEditModel editModel = getEditModel(aProject, editModelID);
      return editModel.createScribbler(domains, true);
   }

   /*
    * (non-Javadoc)
    * 
    * @see com.ibm.soa.infrastructure.emf.IEditModelFactory1#createScribblerForWrite(org.eclipse.core.resources.IProject,
    *      java.lang.String, com.ibm.soa.infrastructure.emf.IScribblerDomain[])
    */
   public IEditModelScribbler createScribblerForWrite(IProject aProject,
         String editModelID, IScribblerDomain[] domains)
         throws EditModelException {
      IEditModel editModel = getEditModel(aProject, editModelID);
      return editModel.createScribbler(domains, false);
   }

}
