/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.tests.infrastructure.util;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.stp.core.infrastructure.emf.EditModelEvent;
import org.eclipse.stp.core.infrastructure.emf.IEditModel;
import org.eclipse.stp.core.infrastructure.emf.IEditModelListener;

public class TestEditModelListener implements IEditModelListener {

   private static final EditModelEvent[] NO_EVENTS = new EditModelEvent[0];

   private static final int[]            ALL_CODES = new int[] {
         EditModelEvent.ADDED_RESOURCE, EditModelEvent.REMOVED_RESOURCE,
         EditModelEvent.KNOWN_RESOURCES_CHANGED,
         EditModelEvent.KNOWN_RESOURCES_ABOUT_TO_CHANGE,
         EditModelEvent.LOADED_RESOURCE, EditModelEvent.UNLOADED_RESOURCE,
         EditModelEvent.SAVE, EditModelEvent.DIRTY, EditModelEvent.PRE_DISPOSE };

   private final List                    events    = new ArrayList();

   private boolean                       isInterestedInAddedResource;

   private boolean                       isInterestedInRemovedResource;

   private boolean                       isInterestedInKnownResourcesChanged;

   private boolean                       isInterestedInKnownResourcesAboutToChange;

   private boolean                       isInterestedInLoadedResource;

   private boolean                       isInterestedInUnloadedResource;

   private boolean                       isInterestedInSave;

   private boolean                       isInterestedInDirty;

   private boolean                       isInterestedInRevert;

   private boolean                       isInterestedInPreDispose;

   public TestEditModelListener() {
      this(ALL_CODES);
   }

   public TestEditModelListener(int anInterestingEvent) {
      this(new int[] { anInterestingEvent });
   }

   public TestEditModelListener(int[] theInterestingEvents) {
      for (int i = 0; i < theInterestingEvents.length; i++) {
         switch (theInterestingEvents[i]) {
            case EditModelEvent.ADDED_RESOURCE:
               isInterestedInAddedResource = true;
               break;
            case EditModelEvent.REMOVED_RESOURCE:
               isInterestedInRemovedResource = true;
               break;
            case EditModelEvent.KNOWN_RESOURCES_CHANGED:
               isInterestedInKnownResourcesChanged = true;
               break;
            case EditModelEvent.KNOWN_RESOURCES_ABOUT_TO_CHANGE:
               isInterestedInKnownResourcesAboutToChange = true;
               break;
            case EditModelEvent.LOADED_RESOURCE:
               isInterestedInLoadedResource = true;
               break;
            case EditModelEvent.UNLOADED_RESOURCE:
               isInterestedInUnloadedResource = true;
               break;
            case EditModelEvent.SAVE:
               isInterestedInSave = true;
               break;
            case EditModelEvent.DIRTY:
               isInterestedInDirty = true;
               break;
            case EditModelEvent.REVERT:
               isInterestedInRevert = true;
               break;
            case EditModelEvent.PRE_DISPOSE:
               isInterestedInPreDispose = true;
         }
      }
   }

   public void editModelChanged(IEditModel notifyingEditModel,
         EditModelEvent anEvent) {

      switch (anEvent.getEventCode()) {
         case EditModelEvent.ADDED_RESOURCE:
            if (isInterestedInAddedResource)
               events.add(anEvent);
            break;
         case EditModelEvent.REMOVED_RESOURCE:
            if (isInterestedInRemovedResource)
               events.add(anEvent);
            break;
         case EditModelEvent.KNOWN_RESOURCES_CHANGED:
            if (isInterestedInKnownResourcesChanged)
               events.add(anEvent);
            break;
         case EditModelEvent.KNOWN_RESOURCES_ABOUT_TO_CHANGE:
            if (isInterestedInKnownResourcesAboutToChange)
               events.add(anEvent);
            break;
         case EditModelEvent.LOADED_RESOURCE:
            if (isInterestedInLoadedResource)
               events.add(anEvent);
            break;
         case EditModelEvent.UNLOADED_RESOURCE:
            if (isInterestedInUnloadedResource)
               events.add(anEvent);
            break;
         case EditModelEvent.SAVE:
            if (isInterestedInSave)
               events.add(anEvent);
            break;
         case EditModelEvent.DIRTY:
            if (isInterestedInDirty)
               events.add(anEvent);
            break;
         case EditModelEvent.REVERT:
            if (isInterestedInRevert)
               events.add(anEvent);
            break;

         case EditModelEvent.PRE_DISPOSE:
            if (isInterestedInPreDispose)
               events.add(anEvent);
            break;
      }
   }

   public EditModelEvent[] getEvents() {
      if (events.size() == 0)
         return NO_EVENTS;
      return (EditModelEvent[]) events
            .toArray(new EditModelEvent[events.size()]);
   }

}
