/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.tests.infrastructure.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.emf.IEditModelErrorHandler;

public class TestErrorHandler implements IEditModelErrorHandler {

   public boolean handledLoadFailed    = false;

   public boolean handleSaveFailed     = false;

   public boolean handleRevertFailed   = false;

   public boolean handleGeneralFailure = false;

   public void handleLoadFailed(URI anAttemptedURI, Exception e) {
      handledLoadFailed = true;

   }

   public void handleLoadFailed(Resource resource, Exception e) {
      handledLoadFailed = true;

   }

   public void handleSaveFailed(Resource resource, Exception e) {
      handleSaveFailed = true;

   }

   public void handleRevertFailed(Resource resource, Exception e) {
      handleRevertFailed = true;

   }

   public void handleGeneralFailure(Object target, Exception e) {
      handleGeneralFailure = true;

   }

}
