/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.tests.infrastructure.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.emf.IHumanInteractionController;

public class TestHumanInteractionController implements
      IHumanInteractionController {

   private TestResponse response;

   public TestHumanInteractionController(Boolean expectedResponse) {
      response = new TestResponse(expectedResponse);
   }

   public class TestResponse implements Response {

      private Boolean shouldProceed;

      TestResponse(Boolean toProceed) {
         shouldProceed = toProceed;
      }

      public Boolean shouldProceed() {
         return shouldProceed;
      }

   }

   public Response requestDirection(IStatus status) {
      return response;
   }

   public Response declareInformation(IStatus status) {
      return response;
   }

   public Response declareWarning(IStatus status) {
      return response;
   }

   public Response declareError(IStatus status) {
      return response;
   }

}
