/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.tests.infrastructure.util;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.stp.core.tests.infrastructure.InfrastructureTestsPlugin;

public class TestOperation extends AbstractOperation implements
      IUndoableOperation {

   private String            lastDisplayName;

   private TestOperationArgs lastArgs;

   public TestOperation() {
      super("Set the display name"); //$NON-NLS-1$
   }

   public IStatus execute(IProgressMonitor monitor, IAdaptable info)
         throws ExecutionException {

      TestOperationArgs args = (TestOperationArgs) info
            .getAdapter(TestOperationArgs.class);
      lastArgs = new TestOperationArgs(args);
      if (lastArgs != null) {

         EJBJar jar = lastArgs.getEjbJar();
         lastDisplayName = jar.getDisplayName();

         jar.setDisplayName(lastArgs.getNewDisplayName());

         return Status.OK_STATUS;

      }

      return new Status(IStatus.ERROR, InfrastructureTestsPlugin.PLUGIN_ID, 0,
            "Could not execute Test Operations, no Args available.", //$NON-NLS-1$
            null);
   }

   public IStatus redo(IProgressMonitor monitor, IAdaptable info)
         throws ExecutionException {

      return execute(monitor, info);
   }

   public IStatus undo(IProgressMonitor monitor, IAdaptable info)
         throws ExecutionException {

      if (lastArgs != null) {

         EJBJar jar = lastArgs.getEjbJar();
         jar.setDisplayName(lastDisplayName);

         return Status.OK_STATUS;
      }

      return new Status(IStatus.ERROR, InfrastructureTestsPlugin.PLUGIN_ID, 0,
            "Could not execute Test Operations, no Args available.", //$NON-NLS-1$
            null);
   }

}
