/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.tests.infrastructure.util;

import junit.framework.Assert;

import org.eclipse.core.runtime.IProgressMonitor;

/**
 * This class ensures that a progress monitor is actively used throughout a
 * method.
 * 
 * There are three modes of operation. The first modeis to ensure that a minimum
 * number of messages is posted. The second mode is to ensure that a set of
 * exact messages is satisfied. And the last mode is to ensure that at least the
 * set of provided messages is provided but more messages is acceptable.
 */
public class TestProgressMonitor implements IProgressMonitor {

   private static final boolean LOG_PROGRESS_MESSAGES = false;

   private int                  minimumDensity;

   private boolean              strictEnforcement;

   private String[]             requiredMessages;

   private int                  current               = 0;

   private int                  taskCompletionStack;

   private String               taskName;

   public TestProgressMonitor(int theMinimumDensity) {
      minimumDensity = theMinimumDensity;
      strictEnforcement = false;
   }

   public TestProgressMonitor(String[] theRequiredMessages,
         boolean toEnforceStrictly) {
      minimumDensity = theRequiredMessages.length;
      requiredMessages = theRequiredMessages;
      strictEnforcement = toEnforceStrictly;
   }

   public void assertMessages(String message) {
      Assert
            .assertEquals(
                  "The number of begun tasks should match the number of completed tasks.", //$NON-NLS-1$
                  0, taskCompletionStack);
      if (strictEnforcement)
         Assert.assertEquals(message, minimumDensity, current);
      else
         Assert.assertTrue(message, minimumDensity <= current);
   }

   public void beginTask(String name, int totalWork) {
      if (requiredMessages == null || requiredMessages[current].equals(name))
         ++current;
      taskCompletionStack++;
      if (LOG_PROGRESS_MESSAGES)
         System.out.println(name);
      taskName = name;

   }

   public void done() {
      taskCompletionStack--;
      if (LOG_PROGRESS_MESSAGES)
         System.out.println("Progress monitor for \"" + taskName + "\" Done!"); //$NON-NLS-1$ //$NON-NLS-2$
   }

   public void internalWorked(double work) {
      // TODO Auto-generated method stub

   }

   public boolean isCanceled() {
      // TODO Auto-generated method stub
      return false;
   }

   public void setCanceled(boolean value) {
      // TODO Auto-generated method stub

   }

   public void setTaskName(String name) {
      // TODO Auto-generated method stub

   }

   public void subTask(String name) {
      if (requiredMessages == null || requiredMessages[current].equals(name))
         ++current;
      if (LOG_PROGRESS_MESSAGES)
         System.out.println(name);
   }

   public void worked(int work) {
      // TODO Auto-generated method stub

   }

}
