/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.tests.infrastructure.util;

import java.lang.ref.WeakReference;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBJarResourceFactory;
import org.eclipse.jst.j2ee.internal.J2EEInit;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.EMFResourceFactoryRegistry;

public class TestWorkspace {

   private static final String TEST_PROJECT_NAME = "EMFResourceTests"; //$NON-NLS-1$

   public static void init() {

      ProjectUnzipUtil util = new ProjectUnzipUtil(new Path(
            "/testdata/EMFResourceTests.zip"), //$NON-NLS-1$
            new String[] { TEST_PROJECT_NAME });

      if (!getTestProject().isAccessible()) {
         util.createProjects();
      } else {
         util.reset();
      }

      // we use some of the J2EE code to test our framework
      // This should not be considered a test of the J2EE code.
      J2EEInit.init();
      EJBJarResourceFactory.register(EMFResourceFactoryRegistry.sINSTANCE);
   }

   public static IProject getTestProject() {
      return ResourcesPlugin.getWorkspace().getRoot().getProject(
            TEST_PROJECT_NAME);
   }

   /**
    * The following method tries to aggressively encourage a GC cycle to take
    * place. It should be used judiciously.
    */
   public static void encourageGC() {

      Object o = new Object();
      WeakReference weakRef = new WeakReference(o);
      o = null;

      // If the JRE is an IBM JRE, the following
      // line will force a GC cycle; otherwise
      // a GC() will only be "suggested".
      System.gc();

      long freeMemory = Runtime.getRuntime().freeMemory();
      int count = 0;
      while (weakRef.get() != null && count++ < 0) {
         // a hack to inhale memory in order to encourage a GC
         byte[] availablespace = new byte[(int) freeMemory];
         availablespace[0] = 0;
         availablespace = null;
         System.gc();

      }
   }
}
