/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.sca.diagram.edit.parts.ComponentReferenceEditPart;
import org.eclipse.stp.sca.diagram.edit.parts.ReferenceEditPart;
import org.eclipse.stp.sca.diagram.edit.policies.ReferencePromoteItemSemanticEditPolicy;
import org.eclipse.stp.sca.diagram.router.lib.ConnectionLayerExEx;
import org.eclipse.stp.sca.diagram.router.lib.SCAPolylineConnectionEx;

public class ReferencePromoteEditPart
extends ConnectionNodeEditPart {
    public static final int VISUAL_ID = 3001;
    private ConnectionRouter rectilinearRouter = null;

    public ReferencePromoteEditPart(View view) {
        super(view);
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        ReferenceEditPart ep = (ReferenceEditPart)this.getSource();
        Rectangle ref = ep.getFigure().getBounds();
        RectangleFigure ifigure = new RectangleFigure();
        ifigure.setBounds(new Rectangle(ref.x + 12, ref.y + 12, 2, 2));
        return new SlidableAnchor((IFigure)ifigure);
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        ComponentReferenceEditPart ep = (ComponentReferenceEditPart)this.getTarget();
        Rectangle ref = ep.getFigure().getBounds();
        RectangleFigure ifigure = new RectangleFigure();
        ifigure.setBounds(new Rectangle(ref.x + 12, ref.y + 32, 3, 3));
        return new SlidableAnchor((IFigure)ifigure);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ReferencePromoteItemSemanticEditPolicy());
    }

    protected Connection createConnectionFigure() {
        return new PromoteFigure();
    }

    protected void installRouter() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        RoutingStyle style = (RoutingStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.ROUTING_STYLE);
        if (style != null && cLayer instanceof ConnectionLayerExEx) {
            ConnectionLayerExEx cLayerEx = (ConnectionLayerExEx)cLayer;
            if (Routing.RECTILINEAR_LITERAL == style.getRouting()) {
                if (this.rectilinearRouter == null) {
                    this.rectilinearRouter = cLayerEx.getScaPromoteReferenceEdgeRectilinearRouter();
                }
                this.getConnectionFigure().setConnectionRouter(this.rectilinearRouter);
                ((PromoteFigure)this.getFigure()).setRouterIsRectilinear(true);
                this.refreshRouterChange();
                return;
            }
        }
        ((PromoteFigure)this.getFigure()).setRouterIsRectilinear(false);
        super.installRouter();
    }

    protected void refreshVisuals() {
        this.refreshSourceAnchor();
        this.refreshTargetAnchor();
        super.refreshVisuals();
    }

    public class PromoteFigure
    extends SCAPolylineConnectionEx {
        PromoteFigure() {
            this.setFill(true);
            this.setFillXOR(false);
            this.setOutline(true);
            this.setOutlineXOR(false);
            this.setLineWidth(1);
            this.setLineStyle(2);
            this.setForegroundColor(ColorConstants.black);
        }
    }
}

