/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.diagram.part.Messages;
import org.eclipse.stp.sca.diagram.part.ScaDiagramEditorPlugin;
import org.eclipse.stp.sca.diagram.part.ScaDiagramEditorUtil;
import org.eclipse.stp.sca.diagram.part.ScaNewDiagramFileWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ScaInitDiagramFileAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private URI domainModelURI;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.domainModelURI = null;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        IFile file = (IFile)((IStructuredSelection)selection).getFirstElement();
        this.domainModelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        action.setEnabled(true);
    }

    private Shell getShell() {
        return this.targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        EObject diagramRoot = null;
        try {
            Resource resource = resourceSet.getResource(this.domainModelURI, true);
            diagramRoot = (EObject)resource.getContents().get(0);
        }
        catch (WrappedException ex) {
            ScaDiagramEditorPlugin.getInstance().logError("Unable to load resource: " + this.domainModelURI, ex);
        }
        if (diagramRoot == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ScaInitDiagramFileAction_InitDiagramFileResourceErrorDialogTitle, (String)Messages.ScaInitDiagramFileAction_InitDiagramFileResourceErrorDialogMessage);
            return;
        }
        ScaNewDiagramFileWizard wizard = new ScaNewDiagramFileWizard(this.domainModelURI, diagramRoot, editingDomain);
        wizard.setWindowTitle(NLS.bind((String)Messages.ScaInitDiagramFileAction_InitDiagramFileWizardTitle, (Object)"Sca"));
        ScaDiagramEditorUtil.runWizard(this.getShell(), wizard, "InitDiagramFile");
    }
}

