/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures.connectionanchors.impl;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchorSupport;

public class BpmnAwareAnchorSupport
implements IModelAwareAnchorSupport {
    public Point getLocation(IModelAwareAnchor anchor, Point reference) {
        if (anchor.getConnectionType() == null || anchor.getAnchorPositionningStyle() == 0) {
            return this.returnDefaultLocation(anchor, reference);
        }
        if (anchor.getConnectionType().startsWith(String.valueOf(3001))) {
            if (anchor.isSourceAnchor() == 2) {
                return this.returnDefaultLocation(anchor, reference);
            }
            Rectangle thisBox = new Rectangle();
            this.computeOwnerBounds(anchor, thisBox);
            Point thisCenter = thisBox.getCenter();
            Point res = new Point();
            if (!anchor.getConnectionType().equals(String.valueOf(3001))) {
                res.x = thisCenter.x;
                res.y = thisBox.y + thisBox.height;
            } else {
                res.x = anchor.isSourceAnchor() == 0 ? thisBox.x + thisBox.width : thisBox.x;
                if (anchor.getCount() > 0 && anchor.getOrderNumber() != -1) {
                    int constraint = 0;
                    if (anchor.getConnectionOwner() instanceof SequenceEdgeEditPart.EdgeFigure) {
                        int n = constraint = anchor.isSourceAnchor() == 0 ? ((SequenceEdgeEditPart.EdgeFigure)anchor.getConnectionOwner()).getSourceGatewayConstraint() : ((SequenceEdgeEditPart.EdgeFigure)anchor.getConnectionOwner()).getTargetGatewayConstraint();
                    }
                    if (constraint == 1) {
                        res.y = thisBox.y;
                        res.x = thisCenter.x;
                    } else if (constraint == 2) {
                        res.x = thisCenter.x;
                        res.y = thisBox.y + thisBox.height;
                    } else if (constraint == 3) {
                        res.y = thisCenter.y;
                    } else {
                        int height = thisBox.height;
                        res.y = thisBox.y + height / (anchor.getCount() + 1) * (anchor.getOrderNumber() + 1);
                    }
                } else {
                    res.y = thisCenter.y;
                }
            }
            return res;
        }
        if (anchor.getConnectionType().startsWith(String.valueOf(3002))) {
            if (anchor.getOwner() == null || anchor.getConnectionOwner() == null || anchor.isSourceAnchor() == 2) {
                return this.returnDefaultLocation(anchor, reference);
            }
            Connection conn = anchor.getConnectionOwner();
            Rectangle thisBox = new Rectangle();
            this.computeOwnerBounds(anchor, thisBox);
            Point thisCenter = thisBox.getCenter();
            Point otherCenter = null;
            if (anchor.isSourceAnchor() == 0) {
                if (conn.getTargetAnchor().getOwner() == null) {
                    otherCenter = conn.getTargetAnchor().getReferencePoint();
                } else {
                    otherCenter = conn.getTargetAnchor().getOwner().getBounds().getCenter();
                    conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)otherCenter);
                }
            } else if (conn.getSourceAnchor().getOwner() == null) {
                otherCenter = conn.getSourceAnchor().getReferencePoint();
            } else {
                otherCenter = conn.getSourceAnchor().getOwner().getBounds().getCenter();
                conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)otherCenter);
            }
            Point res = new Point();
            res.y = thisCenter.y > otherCenter.y ? thisBox.y : thisBox.y + thisBox.height;
            if (anchor.getCount() > 0 && anchor.getOrderNumber() != -1) {
                int width = thisBox.width;
                res.x = thisBox.x + width / (anchor.getCount() + 1) * (anchor.getOrderNumber() + 1);
            } else {
                res.x = thisCenter.x;
            }
            return res;
        }
        if (reference == null) {
            Point thisCenter = anchor.getOwner().getBounds().getCenter();
            anchor.getOwner().translateToAbsolute((Translatable)thisCenter);
            return thisCenter;
        }
        return anchor.getDefaultLocation(reference);
    }

    protected Point returnDefaultLocation(IModelAwareAnchor anchor, Point reference) {
        if (reference == null && anchor.getOwner() != null) {
            this.computeOwnerBounds(anchor, Rectangle.SINGLETON);
            Point thisCenter = Rectangle.SINGLETON.getCenter();
            return thisCenter;
        }
        return anchor.getDefaultLocation(reference);
    }

    protected void computeOwnerBounds(IModelAwareAnchor anchor, Rectangle result) {
        IModelAwareAnchor.INodeFigureAnchorTerminalUpdatable n = anchor.getCastedOwner();
        n.computeAbsoluteHandleBounds(result);
    }
}

