/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Lane;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.policies.ResizableShapeEditPolicyEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizableLaneEditPolicy
extends ResizableShapeEditPolicyEx {
    public static List<Activity> findContainedActivities(ChangeBoundsRequest request, LaneEditPart laneEditPart) {
        Rectangle rect = laneEditPart.getFigure().getBounds().getCopy();
        laneEditPart.getFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        return ResizableLaneEditPolicy.findContainedActivities(rect, laneEditPart);
    }

    public static List<Activity> findContainedActivities(Rectangle rect, LaneEditPart laneEditPart) {
        return ResizableLaneEditPolicy.findContainedActivities(rect, laneEditPart.getViewer());
    }

    public static List<Activity> findContainedActivities(Rectangle rect, EditPartViewer viewer) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (Object fig : viewer.getVisualPartMap().keySet()) {
            Object part = viewer.getVisualPartMap().get(fig);
            if (!(part instanceof ActivityEditPart) && !(part instanceof Activity2EditPart) && !(part instanceof SubProcessEditPart)) continue;
            Rectangle bounds = ((IGraphicalEditPart)part).getFigure().getBounds().getCopy();
            ((IGraphicalEditPart)part).getFigure().translateToAbsolute((Translatable)bounds);
            if ((bounds.y <= rect.y || bounds.y >= rect.y + rect.height) && (bounds.y + bounds.height <= rect.y || bounds.y + bounds.height >= rect.y + rect.height)) continue;
            activities.add((Activity)((IGraphicalEditPart)part).resolveSemanticElement());
        }
        return activities;
    }

    @Override
    protected Handle createHandle(GraphicalEditPart owner, int direction) {
        return new LaneResizeHandle(owner, direction);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move children");
        req.setEditParts(request.getEditParts());
        req.setMoveDelta(new Point(0, req.getMoveDelta().y));
        req.setSizeDelta(new Dimension(0, req.getSizeDelta().height));
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        req.setResizeDirection(5);
        List<Activity> activities = ResizableLaneEditPolicy.findContainedActivities(request, (LaneEditPart)this.getHost());
        CompoundCommand compound = new CompoundCommand();
        SetActivitiesCommand command = new SetActivitiesCommand((Lane)((IGraphicalEditPart)this.getHost()).resolveSemanticElement(), activities);
        compound.add((Command)new ICommandProxy((ICommand)command));
        compound.add(this.getHost().getParent().getCommand((Request)req));
        return compound;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        if (request.getMoveDelta().y < 0 && this.getHostFigure().getBounds().y == PoolPoolCompartmentEditPart.INSETS.top) {
            return UnexecutableCommand.INSTANCE;
        }
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setEditParts(request.getEditParts());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        req.setResizeDirection(request.getResizeDirection());
        CompoundCommand compound = new CompoundCommand();
        compound.add(this.getHost().getParent().getCommand((Request)req));
        return compound;
    }

    protected void replaceHandleDragEditPartsTracker(Handle handle) {
        if (handle instanceof AbstractHandle) {
            AbstractHandle h = (AbstractHandle)handle;
            h.setDragTracker((DragTracker)new DragEditPartsTrackerEx(this.getHost()){

                protected void addSourceCommands(boolean isMove, CompoundCommand command) {
                    if (!this.isCloneActive()) {
                        Request request = this.getTargetRequest();
                        request.setType((Object)(isMove ? "move" : "drag"));
                        command.add(ResizableLaneEditPolicy.this.getHost().getCommand(request));
                        request.setType((Object)"drop");
                    } else {
                        super.addSourceCommands(isMove, command);
                    }
                }
            });
        }
    }

    protected static class LaneResizeHandle
    extends ResizableShapeEditPolicyEx.ResizeHandleEx {
        public LaneResizeHandle(GraphicalEditPart owner, int direction) {
            super(owner, direction);
        }

        protected DragTracker createDragTracker() {
            return new ResizeTracker(this.getOwner(), this.cursorDirection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetActivitiesCommand
    extends AbstractTransactionalCommand {
        private Lane _lane;
        private List<Activity> _activities;
        private CreateViewAndElementRequest _request;

        public SetActivitiesCommand(Lane elt, List<Activity> activities) {
            super((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)elt), BpmnDiagramMessages.ResizableGroupEditPolicy_command_name, SetActivitiesCommand.getWorkspaceFiles((EObject)elt));
            this._lane = elt;
            this._activities = activities;
        }

        public SetActivitiesCommand(List<Activity> activities, CreateViewAndElementRequest request, EObject container) {
            super((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)container), BpmnDiagramMessages.ResizableActivityEditPolicy_groups_command_name, SetActivitiesCommand.getWorkspaceFiles((EObject)container));
            this._request = request;
            this._activities = activities;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this._request != null) {
                this._lane = (Lane)this._request.getViewAndElementDescriptor().getCreateElementRequestAdapter().resolve();
            }
            ArrayList<Activity> toRemove = new ArrayList<Activity>();
            ArrayList<Activity> activities = new ArrayList<Activity>(this._activities);
            for (Activity a : this._lane.getActivities()) {
                if (activities.remove(a)) continue;
                toRemove.add(a);
            }
            this._lane.getActivities().removeAll(toRemove);
            this._lane.getActivities().addAll(activities);
            return CommandResult.newOKCommandResult();
        }
    }
}

