/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.util.UIModificationValidator;
import org.eclipse.stp.bpmn.validation.IResourceImportersRegistry;
import org.eclipse.stp.bpmn.validation.builder.BatchValidationBuilder;
import org.eclipse.stp.bpmn.validation.builder.ResourceImportersRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnValidationPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.stp.bpmn.validation";
    public static final String BATCH_VALIDATION_BUILD_ABLE_NATURE_ID = "org.eclipse.stp.bpmn.validation.BatchValidationBuildAbleNature";
    public static String GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID = BatchValidationBuilder.GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID;
    private static BpmnValidationPlugin plugin;
    private static WeakHashMap<IProject, Map<String, IResourceImportersRegistry>> CACHE;
    private ISaveParticipant _saveParticiapnt;
    private List<IValidationMarkerCreationHook> _creationMarkerCallBacks;

    static {
        CACHE = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        CACHE = new WeakHashMap();
        this._saveParticiapnt = new ISaveParticipant(){

            public void doneSaving(ISaveContext context) {
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void rollback(ISaveContext context) {
            }

            public void saving(ISaveContext context) throws CoreException {
                Map importIndexes = (Map)CACHE.get(context.getProject());
                if (importIndexes != null) {
                    for (Map.Entry entry : importIndexes.entrySet()) {
                        ((IResourceImportersRegistry)entry.getValue()).save(context.getProject(), (String)entry.getKey(), (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, this._saveParticiapnt);
        new UIModificationValidator().dispose();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        CACHE = null;
        ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
        super.stop(context);
    }

    public static BpmnValidationPlugin getDefault() {
        return plugin;
    }

    public static synchronized IResourceImportersRegistry getResourceImportersRegistry(IProject project, String importersCategoryID, IProgressMonitor monitor) {
        IResourceImportersRegistry res;
        if (CACHE == null) {
            return null;
        }
        Map<String, IResourceImportersRegistry> importIndexes = CACHE.get(project);
        if (importIndexes == null) {
            importIndexes = new HashMap<String, IResourceImportersRegistry>();
            CACHE.put(project, importIndexes);
        }
        if ((res = importIndexes.get(importersCategoryID)) != null) {
            return res;
        }
        res = new ResourceImportersRegistry();
        res.load(project, importersCategoryID, monitor);
        importIndexes.put(importersCategoryID, res);
        return res;
    }

    public void addValidationMarkerCreationHook(IValidationMarkerCreationHook hook) {
        if (this._creationMarkerCallBacks == null) {
            this._creationMarkerCallBacks = new LinkedList<IValidationMarkerCreationHook>();
        }
        if (!this._creationMarkerCallBacks.contains(hook)) {
            this._creationMarkerCallBacks.add(hook);
        }
    }

    public List<IValidationMarkerCreationHook> getCreationMarkerCallBacks() {
        return this._creationMarkerCallBacks;
    }

    public static interface IValidationMarkerCreationHook {
        public void validationMarkerCreated(IMarker var1, EObject var2);
    }
}

