/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.base;

import java.io.File;
import java.net.URI;
import org.apache.log4j.Logger;
import org.eclipse.stp.common.validator.base.FSValidationContext;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;

public class FSValidationContextFactory {
    private static final Logger LOG = Logger.getLogger(FSValidationContextFactory.class);
    private static FSValidationContextFactory instance = null;

    private FSValidationContextFactory() {
    }

    public static FSValidationContextFactory getInstance() {
        if (instance == null) {
            instance = new FSValidationContextFactory();
        }
        return instance;
    }

    public IValidationContext createContext(String filePath) throws ContextInitializationException {
        FSValidationContext context = null;
        File objFile = new File(filePath);
        if (!objFile.exists()) {
            throw new ContextInitializationException("The [" + filePath + "] does not exists on the file system");
        }
        URI contextURI = objFile.getParentFile().toURI();
        LOG.debug((Object)("The context URI for object is: [" + contextURI + "]"));
        URI relativeURI = null;
        relativeURI = contextURI.relativize(objFile.toURI());
        LOG.debug((Object)("The relative URI for object is: [" + relativeURI + "]"));
        context = new FSValidationContext(contextURI, relativeURI);
        LOG.debug((Object)("The object type is: [" + context.getObject().getID().getType().getName() + "]"));
        return context;
    }
}

