/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core.impl.service;

import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.eclipse.stp.common.validator.core.impl.service.InlineSchemaPrefixResolver;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathHelper {
    private static final Logger LOG = Logger.getLogger(XPathHelper.class);
    private static final InlineSchemaPrefixResolver RESOLVER = new InlineSchemaPrefixResolver();
    private static final XPathFactory xPathFactory = XPathFactory.newInstance();

    public static NodeList getXPathResultList(Node context, String xpath) {
        NodeList nodeList = null;
        try {
            XPathExpression xPathExpression = XPathHelper.getXPathExpression(context, xpath);
            Object obj = xPathExpression.evaluate(context, XPathConstants.NODESET);
            if (obj instanceof NodeList) {
                nodeList = (NodeList)obj;
            } else {
                LOG.error((Object)("The XPath Expression evaluation has returned an unexpected result: [" + obj.getClass() + "]"));
            }
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)"Exception while preparing and executing XPath", (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error((Object)"Exception while preparing and executing XPath", (Throwable)e);
        }
        return nodeList;
    }

    public static Node getXPathResultNode(Node context, String xpath) {
        Node node = null;
        try {
            XPathExpression xPathExpression = XPathHelper.getXPathExpression(context, xpath);
            Object obj = xPathExpression.evaluate(context, XPathConstants.NODE);
            if (obj instanceof Node) {
                node = (Node)obj;
            } else if (obj != null) {
                LOG.error((Object)("The XPath Expression evaluation has returned an unexpected result: [" + obj.getClass() + "]"));
            }
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)"Exception while preparing and executing XPath", (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error((Object)"Exception while preparing and executing XPath", (Throwable)e);
        }
        return node;
    }

    private static XPathExpression getXPathExpression(Node nodeContext, String xPath) throws TransformerException {
        XPathExpression xPathExpression = null;
        if (xPathExpression == null) {
            XPath xPathObj = xPathFactory.newXPath();
            xPathObj.setNamespaceContext(RESOLVER);
            try {
                xPathExpression = xPathObj.compile(xPath);
            }
            catch (XPathExpressionException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new TransformerException(e);
            }
        }
        return xPathExpression;
    }
}

