/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.edit.parts;

import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.eid.datamodel.Connection;
import org.eclipse.stp.eid.datamodel.MEPType;
import org.eclipse.stp.eid.datamodel.diagram.edit.policies.ConnectionItemSemanticEditPolicy;
import org.eclipse.swt.graphics.Color;

public class ConnectionEditPart
extends ConnectionNodeEditPart {
    public static final int VISUAL_ID = 3001;
    protected ComponentInstanceConnectionsFigure connectionFigure;

    public ConnectionEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ConnectionItemSemanticEditPolicy());
    }

    protected org.eclipse.draw2d.Connection createConnectionFigure() {
        return new ComponentInstanceConnectionsFigure();
    }

    public ComponentInstanceConnectionsFigure getPrimaryShape() {
        return (ComponentInstanceConnectionsFigure)this.getFigure();
    }

    protected final void handleNotificationEvent(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof Connection && notification.getEventType() == 1) {
            this.getPrimaryShape().updateFace((Connection)notifier);
        }
        super.handleNotificationEvent(notification);
    }

    public class ComponentInstanceConnectionsFigure
    extends PolylineConnectionEx {
        public ComponentInstanceConnectionsFigure() {
            Connection connection = null;
            MEPType sourceMepType = null;
            EObject semanticElem = ConnectionEditPart.this.resolveSemanticElement();
            if (semanticElem instanceof Connection) {
                connection = (Connection)semanticElem;
            }
            if (connection != null) {
                sourceMepType = connection.getMEPValue();
                this.drawLink(sourceMepType);
            }
        }

        private RotatableDecoration createTargetDecoration() {
            PolylineDecoration df = new PolylineDecoration();
            return df;
        }

        private void drawLink(MEPType sourceMepType) {
            this.setSourceDecoration(null);
            if (sourceMepType.getLiteral().compareTo("RobustInOnly") == 0) {
                this.drawRobustInOnlyLink();
            } else if (sourceMepType.getLiteral().compareTo("InOnly") == 0) {
                this.drawInOnlyLink();
            } else if (sourceMepType.getLiteral().compareTo("InOptionalOut") == 0) {
                this.drawInOptionalOutLink();
            } else if (sourceMepType.getLiteral().compareTo("InOut") == 0) {
                this.drawInOutLink();
            }
        }

        private void drawInOnlyLink() {
            this.setFill(true);
            this.setFillXOR(false);
            this.setOutline(true);
            this.setOutlineXOR(false);
            this.setLineWidth(2);
            this.setTargetDecoration(this.createDecorationClosedFilledArrow(2));
            this.setLineStyle(1);
        }

        private void drawInOutLink() {
            this.setFill(true);
            this.setFillXOR(false);
            this.setOutline(true);
            this.setOutlineXOR(false);
            this.setLineWidth(2);
            this.setTargetDecoration(this.createDecorationClosedFilledArrow(2));
            this.setSourceDecoration(this.createDecorationClosedFilledArrow(2));
            this.setLineStyle(1);
        }

        private void drawRobustInOnlyLink() {
            this.setFill(true);
            this.setFillXOR(false);
            this.setOutline(true);
            this.setOutlineXOR(false);
            this.setLineWidth(3);
            this.setTargetDecoration(this.createDecorationClosedFilledArrow(3));
            this.setLineStyle(1);
        }

        private void drawInOptionalOutLink() {
            this.setFill(true);
            this.setFillXOR(false);
            this.setOutline(true);
            this.setOutlineXOR(false);
            this.setLineWidth(2);
            this.setTargetDecoration(this.createDecorationClosedFilledArrow(2));
            this.setSourceDecoration(this.createDecorationClosedArrow());
            this.setLineStyle(1);
        }

        private RotatableDecoration createDecorationClosedFilledArrow(int arrowSize) {
            PolygonDecoration df = new PolygonDecoration();
            df.setFill(true);
            df.setFillXOR(false);
            df.setOutline(true);
            df.setOutlineXOR(false);
            df.setLineWidth(1);
            df.setLineStyle(1);
            PointList pl = new PointList();
            pl.addPoint(ConnectionEditPart.this.getMapMode().DPtoLP(0), ConnectionEditPart.this.getMapMode().DPtoLP(0));
            pl.addPoint(ConnectionEditPart.this.getMapMode().DPtoLP(-arrowSize), ConnectionEditPart.this.getMapMode().DPtoLP(arrowSize));
            pl.addPoint(ConnectionEditPart.this.getMapMode().DPtoLP(-arrowSize), ConnectionEditPart.this.getMapMode().DPtoLP(-arrowSize));
            pl.addPoint(ConnectionEditPart.this.getMapMode().DPtoLP(0), ConnectionEditPart.this.getMapMode().DPtoLP(0));
            df.setTemplate(pl);
            df.setScale((double)ConnectionEditPart.this.getMapMode().DPtoLP(7), (double)ConnectionEditPart.this.getMapMode().DPtoLP(arrowSize));
            return df;
        }

        private RotatableDecoration createDecorationClosedArrow() {
            PolygonDecoration df = new PolygonDecoration();
            df.setFill(true);
            df.setFillXOR(false);
            df.setOutline(true);
            df.setOutlineXOR(false);
            df.setLineWidth(1);
            df.setLineStyle(1);
            PointList pl = new PointList();
            pl.addPoint(ConnectionEditPart.this.getMapMode().DPtoLP(0), ConnectionEditPart.this.getMapMode().DPtoLP(0));
            pl.addPoint(ConnectionEditPart.this.getMapMode().DPtoLP(-2), ConnectionEditPart.this.getMapMode().DPtoLP(2));
            pl.addPoint(ConnectionEditPart.this.getMapMode().DPtoLP(-2), ConnectionEditPart.this.getMapMode().DPtoLP(-2));
            pl.addPoint(ConnectionEditPart.this.getMapMode().DPtoLP(0), ConnectionEditPart.this.getMapMode().DPtoLP(0));
            df.setTemplate(pl);
            df.setScale((double)ConnectionEditPart.this.getMapMode().DPtoLP(7), (double)ConnectionEditPart.this.getMapMode().DPtoLP(2));
            Color backgroudColor = new Color(null, 255, 255, 255);
            df.setBackgroundColor(backgroudColor);
            return df;
        }

        public void updateFace(Connection connection) {
            this.drawLink(connection.getMEPValue());
        }
    }
}

