/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.eid.datamodel.Graph;
import org.eclipse.stp.eid.datamodel.cimero2Package;
import org.eclipse.stp.eid.datamodel.diagram.expressions.Cimero2EditorAbstractExpression;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorPlugin;

public class Cimero2EditorVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(Cimero2EditorDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Cimero2Editor".equals(view.getType())) {
                return 79;
            }
            return -1;
        }
        return Cimero2EditorVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                Cimero2EditorDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (cimero2Package.eINSTANCE.getGraph().isSuperTypeOf(domainElement.eClass()) && Cimero2EditorVisualIDRegistry.isDiagram((Graph)domainElement)) {
            return 79;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement == null || !"Cimero2Editor".equals(Cimero2EditorVisualIDRegistry.getModelID(containerView))) {
            return -1;
        }
        switch (Cimero2EditorVisualIDRegistry.getVisualID(containerView)) {
            case 79: {
                if (!cimero2Package.eINSTANCE.getComponentInstance().isSuperTypeOf(domainElement.eClass())) break;
                return 1001;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = Cimero2EditorVisualIDRegistry.getModelID(containerView);
        if (!"Cimero2Editor".equals(containerModelID)) {
            return false;
        }
        if ("Cimero2Editor".equals(containerModelID)) {
            containerVisualID = Cimero2EditorVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 79: {
                if (1001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (cimero2Package.eINSTANCE.getConnection().isSuperTypeOf(domainElement.eClass())) {
            return 3001;
        }
        return -1;
    }

    private static boolean isDiagram(Graph element) {
        return true;
    }

    private static boolean evaluate(Cimero2EditorAbstractExpression expression, Object element) {
        Object result = expression.evaluate(element);
        return result instanceof Boolean && (Boolean)result != false;
    }
}

