/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.windows;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.stp.eid.datamodel.Graph;
import org.eclipse.stp.eid.datamodel.Namespace;
import org.eclipse.stp.eid.datamodel.cimero2Factory;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorPlugin;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewNamespaceWindow
extends TitleAreaDialog {
    private Composite aComposite = null;
    private CLabel namespacePrefixLabel = null;
    private Text namespacePrefixText = null;
    private CLabel namespaceValueLabel = null;
    private Text namespaceValueTextField = null;
    private Namespace selectedNamespace = null;

    public NewNamespaceWindow(Shell parentShell) {
        super(parentShell);
    }

    public final void create() {
        super.create();
        this.setTitle("Edit Namespace");
        this.setMessage("Edit Namespace ");
    }

    protected final Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        return ctrl;
    }

    protected final Control createDialogArea(Composite parent) {
        this.aComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 10;
        layout.numColumns = 5;
        this.aComposite.setLayout((Layout)layout);
        this.aComposite.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 4;
        this.namespacePrefixLabel = new CLabel(this.aComposite, 131072);
        this.namespacePrefixLabel.setText(" Prefix ");
        this.namespacePrefixText = new Text(this.aComposite, 0x800800);
        data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 4;
        this.namespacePrefixText.setLayoutData((Object)data);
        if (this.selectedNamespace != null) {
            this.namespacePrefixText.setText(this.selectedNamespace.getPrefix());
        }
        this.namespaceValueLabel = new CLabel(this.aComposite, 131072);
        this.namespaceValueLabel.setText(" Value ");
        this.namespaceValueTextField = new Text(this.aComposite, 0x800800);
        data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 4;
        this.namespaceValueTextField.setLayoutData((Object)data);
        if (this.selectedNamespace != null) {
            this.namespaceValueTextField.setText(this.selectedNamespace.getValue());
        }
        return parent;
    }

    protected final void okPressed() {
        if (this.namespacePrefixText.getText().trim().length() > 0 && this.namespaceValueTextField.getText().trim().length() > 0) {
            try {
                new Cimero2EditorDiagramEditorUtil();
                Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
                TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.getEditingDomain(new Cimero2EditorDiagramEditorUtil().getResourceSet());
                AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "New Namespace", Collections.EMPTY_LIST){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        if (NewNamespaceWindow.this.selectedNamespace == null) {
                            Namespace namespace = cimero2Factory.eINSTANCE.createNamespace();
                            namespace.setPrefix(NewNamespaceWindow.this.namespacePrefixText.getText());
                            namespace.setValue(NewNamespaceWindow.this.namespaceValueTextField.getText());
                            graph.getNamespaces().add((Object)namespace);
                        } else {
                            NewNamespaceWindow.this.selectedNamespace.setPrefix(NewNamespaceWindow.this.namespacePrefixText.getText());
                            NewNamespaceWindow.this.selectedNamespace.setValue(NewNamespaceWindow.this.namespaceValueTextField.getText());
                        }
                        return CommandResult.newOKCommandResult();
                    }
                };
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    Cimero2EditorDiagramEditorPlugin.getInstance().logError("Unable to add namespace ", e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            super.okPressed();
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"CimeroEditor Plug-in", (String)"To add a namespace you must set the prefix and the value");
        }
    }

    protected final void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    public final void setCurrentNamespace(Namespace theSelectedNamespace) {
        this.selectedNamespace = theSelectedNamespace;
    }
}

