/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.desccriptor;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentInstanceProperty;
import org.eclipse.stp.eid.datamodel.Property;
import org.eclipse.stp.eid.datamodel.provider.Cimero2EditorEditPlugin;
import org.eclipse.stp.eid.datamodel.util.LoggerTool;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RepeatablePropertyAddDialogCellEditor
extends DialogCellEditor {
    private ComponentInstanceProperty property;

    protected void updateContents(Object value) {
        String propertyName = "";
        if (this.property != null) {
            propertyName = this.property.getModel().getName();
        }
        super.updateContents((Object)("Click to add a new " + propertyName + " property"));
    }

    protected RepeatablePropertyAddDialogCellEditor(Composite parent, ComponentInstanceProperty property) {
        super(parent);
        this.property = property;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        if (this.property != null) {
            ComponentInstanceProperty property = this.property;
            Diagram diagram = null;
            try {
                if (Cimero2EditorEditPlugin.INSTANCE.getActiveEditor() != null) {
                    IDiagramWorkbenchPart diagramPart = (IDiagramWorkbenchPart)Cimero2EditorEditPlugin.INSTANCE.getActiveEditor();
                    diagram = diagramPart.getDiagram();
                }
                if (diagram != null) {
                    TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.getEditingDomain(diagram.eResource().getResourceSet());
                    AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Add a property", Collections.EMPTY_LIST){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            ComponentInstanceProperty repeatablePropertyFather = (ComponentInstanceProperty)property.getSuperProperty();
                            ComponentInstanceProperty propertyToAdd = property.getModel().getComponentInstanceProperty(repeatablePropertyFather);
                            propertyToAdd.setName(this.updateNewPropertyName(propertyToAdd));
                            if (repeatablePropertyFather != null) {
                                repeatablePropertyFather.getSubProperties().add((Object)propertyToAdd);
                            } else {
                                property.getComponentInstance().getProperties().add((Object)propertyToAdd);
                            }
                            ComponentInstance componentInstance = propertyToAdd.getComponentInstance();
                            int iProperty = 0;
                            while (iProperty < componentInstance.getProperties().size()) {
                                ((ComponentInstanceProperty)componentInstance.getProperties().get(iProperty)).reInit();
                                ++iProperty;
                            }
                            return CommandResult.newOKCommandResult();
                        }

                        private String updateNewPropertyName(ComponentInstanceProperty propertyToAdd) {
                            String indice;
                            ComponentInstanceProperty repeatablePropertyFather = (ComponentInstanceProperty)propertyToAdd.getSuperProperty();
                            int indiceToUse = 0;
                            int idComponent = 0;
                            if (repeatablePropertyFather != null) {
                                int i = 0;
                                while (i < repeatablePropertyFather.getSubProperties().size()) {
                                    if (((ComponentInstanceProperty)repeatablePropertyFather.getSubProperties().get(i)).getModel().getName().compareTo(propertyToAdd.getModel().getName()) == 0 && !((Property)repeatablePropertyFather.getSubProperties().get(i)).equals(propertyToAdd)) {
                                        idComponent = i;
                                    }
                                    ++i;
                                }
                                indice = ((Property)repeatablePropertyFather.getSubProperties().get(idComponent)).getName().replaceAll(((ComponentInstanceProperty)repeatablePropertyFather.getSubProperties().get(idComponent)).getModel().getName(), "0");
                            } else {
                                int i = 0;
                                while (i < property.getComponentInstance().getProperties().size()) {
                                    if (((ComponentInstanceProperty)property.getComponentInstance().getProperties().get(i)).getModel().getName().compareTo(propertyToAdd.getModel().getName()) == 0 && !((ComponentInstanceProperty)property.getComponentInstance().getProperties().get(i)).equals(propertyToAdd)) {
                                        idComponent = i;
                                    }
                                    ++i;
                                }
                                indice = ((ComponentInstanceProperty)property.getComponentInstance().getProperties().get(idComponent)).getName().replaceAll(((ComponentInstanceProperty)property.getComponentInstance().getProperties().get(idComponent)).getModel().getName(), "0");
                            }
                            indiceToUse = Integer.parseInt(indice) + 1;
                            return String.valueOf(propertyToAdd.getModel().getName()) + indiceToUse;
                        }
                    };
                    try {
                        OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
                    }
                    catch (ExecutionException e) {
                        LoggerTool.logger.warning("Unable to add the property" + property.getName() + "\n" + (Object)((Object)e));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fireEditorValueChanged(true, true);
        return null;
    }

    protected Button createButton(Composite parent) {
        Button button = super.createButton(parent);
        Image img = this.getIconImage("plus");
        button.setSize(18, 18);
        button.setImage(img);
        button.setText("");
        return button;
    }

    private final Image getIconImage(String imageName) {
        return this.getImageDescriptor(imageName).createImage();
    }

    private final ImageDescriptor getImageDescriptor(String imageName) {
        ImageDescriptor imageDesc = Cimero2EditorEditPlugin.getBundledImageDescriptor("icons/full/obj16/" + imageName + ".gif");
        return imageDesc;
    }
}

