/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.runtime.comboproviders;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stp.im.runtime.comboproviders.ComboEntries;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;

public class CustomComboPropertyDescriptor
extends ComboBoxPropertyDescriptor {
    private String[] mData;
    private String[] mDisplay;
    private int mDefault;

    public CustomComboPropertyDescriptor(String id, String displayName, ComboEntries entries, int default1) {
        super((Object)id, displayName, new String[0]);
        this.mData = entries.getValues();
        this.mDisplay = entries.getLabels();
        this.mDefault = default1;
        this.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    int i = 0;
                    while (i < CustomComboPropertyDescriptor.this.mData.length) {
                        if (CustomComboPropertyDescriptor.this.mData[i].equals(element)) {
                            return CustomComboPropertyDescriptor.this.mDisplay[i];
                        }
                        ++i;
                    }
                    return CustomComboPropertyDescriptor.this.mDisplay[CustomComboPropertyDescriptor.this.mDefault];
                }
                return super.getText(element);
            }
        });
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return new ComboBoxCellEditor(parent, this.mDisplay, 8){

            protected Object doGetValue() {
                Integer i = (Integer)super.doGetValue();
                return CustomComboPropertyDescriptor.this.mData[i];
            }

            protected void doSetValue(Object value) {
                int val = CustomComboPropertyDescriptor.this.mDefault;
                int i = 0;
                while (i < CustomComboPropertyDescriptor.this.mData.length) {
                    if (CustomComboPropertyDescriptor.this.mData[i].equals(value)) {
                        val = i;
                        break;
                    }
                    ++i;
                }
                super.doSetValue((Object)new Integer(val));
            }
        };
    }
}

