/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.tool.in.bpmneditor.dialog;

import java.util.HashMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BpmnImVersionDialog
extends TitleAreaDialog {
    private Composite aComposite = null;
    private CLabel currentVersionLabelLabel = null;
    private CLabel currentVersionLabelText = null;
    private CLabel newVersionLabel = null;
    private Text newVersionText = null;
    private Group versioningTypeGroup = null;
    private Button versionOnCurrentDiagramButton = null;
    private Button versionCreateNewDiagram = null;
    private String currentVersion = null;
    private BpmnDiagram bpmnDiagram = null;

    public BpmnImVersionDialog(Shell parentShell, BpmnDiagram bpmnDiagram) {
        super(parentShell);
        this.bpmnDiagram = bpmnDiagram;
        EAnnotation versionAnnotation = bpmnDiagram.getEAnnotation("im.version");
        if (versionAnnotation != null) {
            this.currentVersion = (String)versionAnnotation.getDetails().get((Object)"im.process.version");
        }
    }

    public void create() {
        super.create();
        this.setTitle("Version Management");
        this.setMessage("Versioning of " + (this.bpmnDiagram != null ? (this.bpmnDiagram.getName() != null ? this.bpmnDiagram.getName() : this.bpmnDiagram.getID()) : ""));
    }

    protected Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        return ctrl;
    }

    protected Control createDialogArea(Composite parent) {
        this.aComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 10;
        layout.numColumns = 5;
        this.aComposite.setLayout((Layout)layout);
        this.aComposite.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 4;
        this.currentVersionLabelLabel = new CLabel(this.aComposite, 131072);
        this.currentVersionLabelLabel.setText(" Current Version ");
        this.currentVersionLabelText = new CLabel(this.aComposite, 0x800800);
        this.currentVersionLabelText.setText(this.currentVersion != null ? this.currentVersion : "Not versioned (0)");
        data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 4;
        this.currentVersionLabelText.setLayoutData((Object)data);
        this.newVersionLabel = new CLabel(this.aComposite, 131072);
        this.newVersionLabel.setText(" New Version ");
        this.newVersionText = new Text(this.aComposite, 0x800800);
        data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 4;
        this.newVersionText.setLayoutData((Object)data);
        this.versioningTypeGroup = new Group(this.aComposite, 16);
        data = new GridData(768);
        data.horizontalSpan = 5;
        this.versioningTypeGroup.setText(" Versioning ");
        this.versionOnCurrentDiagramButton = new Button((Composite)this.versioningTypeGroup, 16);
        this.versionOnCurrentDiagramButton.setText("On This File");
        this.versionOnCurrentDiagramButton.setBounds(5, 10, 100, 30);
        this.versionCreateNewDiagram = new Button((Composite)this.versioningTypeGroup, 16);
        this.versionCreateNewDiagram.setText("Create New File ");
        this.versionCreateNewDiagram.setBounds(130, 10, 100, 30);
        this.versionOnCurrentDiagramButton.setSelection(true);
        this.versionCreateNewDiagram.setSelection(false);
        this.versioningTypeGroup.setLayoutData((Object)data);
        return parent;
    }

    protected void okPressed() {
        String newVersion = this.newVersionText.getText().trim();
        if (newVersion == null || newVersion.length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"IntermediateModel", (String)"Enter the new version");
            return;
        }
        if (newVersion != null && newVersion.equalsIgnoreCase(this.currentVersion)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"IntermediateModel", (String)"New Version and Old Version has the same value !");
            return;
        }
        if (this.versionCreateNewDiagram.getSelection()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"IntermediateModel", (String)"This mode is not supported yet");
            return;
        }
        if (this.currentVersion == null) {
            EAnnotation ea = EcoreFactory.eINSTANCE.createEAnnotation();
            ea.setSource("im.version");
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("im.process.version", this.newVersionText.getText());
            ea.getDetails().putAll(details);
            this.bpmnDiagram.getEAnnotations().add((Object)ea);
        } else {
            EAnnotation ea = this.bpmnDiagram.getEAnnotation("im.version");
            ea.getDetails().put((Object)"im.process.version", (Object)this.newVersionText.getText());
        }
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }
}

